/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.examples;

import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import timeseriesweka.filters.shapelet_transforms.ApproximateShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.ClusteredShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.distance_functions.CachedSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.ImprovedOnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.OnlineSubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.distance_functions.SubSeqDistance;
import timeseriesweka.filters.shapelet_transforms.quality_measures.ShapeletQuality;
import weka.core.Instances;

public class ShapeletExamples {
    public static ShapeletTransform st;

    public static Instances basicTransformExample(Instances train) {
        st = new ShapeletTransform();
        st.setSubSeqDistance(new OnlineSubSeqDistance());
        int nosShapelets = (train.numAttributes() - 1) * train.numInstances() / 5;
        if (nosShapelets < 100) {
            nosShapelets = 100;
        }
        st.setNumberOfShapelets(nosShapelets);
        int minLength = 5;
        int maxLength = (train.numAttributes() - 1) / 10;
        if (maxLength < 3) {
            maxLength = 3;
        }
        st.setShapeletMinAndMax(minLength, maxLength);
        st.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.F_STAT);
        st.setLogOutputFile("ShapeletExampleLog.csv");
        Instances shapeletT = null;
        try {
            shapeletT = st.process(train);
        }
        catch (Exception ex) {
            System.out.println("Error performing the shapelet transform" + ex);
            ex.printStackTrace();
            System.exit(0);
        }
        return shapeletT;
    }

    public static Instances clusteredShapeletTransformExample(Instances train) {
        Instances shapeletT = null;
        int nosShapelets = (train.numAttributes() - 1) * train.numInstances() / 50;
        ClusteredShapeletTransform cst = new ClusteredShapeletTransform(st, nosShapelets);
        System.out.println(" Clustering down to " + nosShapelets + " Shapelets");
        System.out.println(" From " + st.getNumberOfShapelets() + " Shapelets");
        try {
            shapeletT = cst.process(train);
        }
        catch (Exception ex) {
            System.out.println("Error performing the shapelet clustering" + ex);
            ex.printStackTrace();
            System.exit(0);
        }
        return shapeletT;
    }

    public static void initializeShapelet(ShapeletTransform s, Instances train) {
        s.setNumberOfShapelets(1);
        int minLength = 15;
        int maxLength = 36;
        s.setShapeletMinAndMax(minLength, maxLength);
        s.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.F_STAT);
        s.supressOutput();
        s.turnOffLog();
    }

    public static void distanceOptimizations(Instances train) {
        Instances shapeletT = null;
        SubSeqDistance[] ssq = new SubSeqDistance[]{new SubSeqDistance(), new OnlineSubSeqDistance(), new CachedSubSeqDistance(), new ImprovedOnlineSubSeqDistance()};
        ShapeletTransform[] st = new ShapeletTransform[ssq.length];
        for (int i = 0; i < st.length; ++i) {
            st[i] = new ShapeletTransform();
            st[i].setSubSeqDistance(ssq[i]);
            ShapeletExamples.initializeShapelet(st[i], train);
        }
        DecimalFormat df = new DecimalFormat("###.####");
        long t1 = 0L;
        long t2 = 0L;
        double[] time = new double[ssq.length];
        try {
            int i;
            for (i = 0; i < time.length; ++i) {
                t1 = System.currentTimeMillis();
                shapeletT = st[i].process(train);
                t2 = System.currentTimeMillis();
                time[i] = (double)(t2 - t1) / 1000.0;
            }
            System.out.println("TIME (seconds)");
            for (i = 0; i < time.length; ++i) {
                System.out.print(ssq[i].getClass().getSimpleName() + "\t");
            }
            System.out.println();
            for (i = 0; i < time.length; ++i) {
                System.out.print(df.format(time[i]) + "\t");
            }
            System.out.println();
        }
        catch (Exception ex) {
            System.out.println("Error performing the shapelet transform" + ex);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static void shapeletEarlyAbandons(Instances train) {
        ShapeletTransform[] s = new ShapeletTransform[4];
        ShapeletTransform[] pruned = new ShapeletTransform[4];
        for (int i = 0; i < s.length; ++i) {
            s[i] = new ShapeletTransform();
            pruned[i] = new ShapeletTransform();
        }
        for (ShapeletTransform s1 : s) {
            ShapeletExamples.initializeShapelet(s1, train);
            s1.setCandidatePruning(false);
        }
        for (ShapeletTransform s1 : pruned) {
            ShapeletExamples.initializeShapelet(s1, train);
            s1.setCandidatePruning(true);
        }
        ShapeletQuality.ShapeletQualityChoice[] choices = ShapeletQuality.ShapeletQualityChoice.values();
        for (int i = 0; i < s.length; ++i) {
            s[i].setQualityMeasure(choices[i]);
            pruned[i].setQualityMeasure(choices[i]);
        }
        DecimalFormat df = new DecimalFormat("###.####");
        try {
            for (int i = 0; i < s.length; ++i) {
                long t1 = System.currentTimeMillis();
                s[i].process(train);
                long t2 = System.currentTimeMillis();
                double time1 = (double)(t2 - t1) / 1000.0;
                t1 = System.currentTimeMillis();
                pruned[i].process(train);
                t2 = System.currentTimeMillis();
                double time2 = (double)(t2 - t1) / 1000.0;
                System.out.println(" ********* QUALITY MEASURE =" + (Object)((Object)s[i].getQualityMeasure()) + "  **********");
                System.out.println(" NO ABANDON \t\t ABANDON\t\t ABANDON/(NO ABANDON)%\t\t SPEED UP ");
                System.out.println(df.format(time1) + "\t\t\t" + df.format(time2) + "\t\t\t" + (int)(100.0 * (time2 / time1)) + "%\t\t\t" + df.format(time1 / time2));
            }
        }
        catch (Exception ex) {
            System.out.println("Error performing the shapelet transform" + ex);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static Instances approxDataTransformExample(Instances train) {
        st = new ApproximateShapeletTransform();
        int nosShapelets = (train.numAttributes() - 1) * train.numInstances() / 5;
        if (nosShapelets < 100) {
            nosShapelets = 100;
        }
        st.setNumberOfShapelets(nosShapelets);
        int minLength = 5;
        int maxLength = (train.numAttributes() - 1) / 10;
        if (maxLength < 3) {
            maxLength = 3;
        }
        st.setShapeletMinAndMax(minLength, maxLength);
        st.setQualityMeasure(ShapeletQuality.ShapeletQualityChoice.F_STAT);
        st.setLogOutputFile("ApproximateTransformExampleLog.csv");
        try {
            ((ApproximateShapeletTransform)st).setSampleLevels(50, 50);
        }
        catch (IOException ex) {
            Logger.getLogger(ShapeletExamples.class.getName()).log(Level.SEVERE, null, ex);
        }
        Instances shapeletT = null;
        try {
            shapeletT = st.process(train);
        }
        catch (Exception ex) {
            System.out.println("Error performing the shapelet transform" + ex);
            ex.printStackTrace();
            System.exit(0);
        }
        return shapeletT;
    }

    public static void main(String[] args) {
        Instances train = null;
        Instances test = null;
        String path = "C:\\LocalData\\Dropbox\\TSC Problems\\";
        String dataset = "SonyAIBORobotSurface1";
        try {
            FileReader r = new FileReader(path + dataset + "\\" + dataset + "_TRAIN.arff");
            train = new Instances(r);
            train.setClassIndex(train.numAttributes() - 1);
            r = new FileReader(path + dataset + "\\" + dataset + "_TEST.arff");
            test = new Instances(r);
            test.setClassIndex(test.numAttributes() - 1);
        }
        catch (Exception e) {
            System.out.println("Unable to load data. Exception thrown =" + e);
            System.exit(0);
        }
        System.out.println("****************** PERFORMING BASIC TRANSFORM *******");
        Instances shapeletT = ShapeletExamples.basicTransformExample(train);
        System.out.println(" Transformed data set =" + shapeletT);
        System.out.println("\n **************** CLUSTERING *******");
        shapeletT = ShapeletExamples.clusteredShapeletTransformExample(train);
        System.out.println(" Clustered Transformed data set =" + shapeletT);
        System.out.println("\n ******Distance calculation optimizations *******");
        ShapeletExamples.distanceOptimizations(train);
        System.out.println("\n ******Shapelet Early Abandons *******");
        ShapeletExamples.shapeletEarlyAbandons(train);
    }
}

