/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.neighboursearch.PerformanceStats;

public class TWEDistance
extends EuclideanDistance {
    double nu = 1.0;
    double lambda = 1.0;
    double degree = 2.0;

    public void setNu(double n) {
        this.nu = n;
    }

    public void setLambda(double n) {
        this.lambda = n;
    }

    public TWEDistance() {
        this.m_DontNormalize = true;
    }

    public TWEDistance(double nu, double lambda) {
        this.m_DontNormalize = true;
        this.nu = nu;
        this.lambda = lambda;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    public double TWE_Distance(double[] a, double[] b) {
        double dist;
        int k;
        int j;
        int i;
        int i2;
        int dim = 1;
        double[][] ta = new double[a.length][dim];
        double[][] tb = new double[a.length][dim];
        double[] tsa = new double[a.length];
        double[] tsb = new double[b.length];
        for (i2 = 0; i2 < tsa.length; ++i2) {
            tsa[i2] = i2 + 1;
        }
        for (i2 = 0; i2 < tsb.length; ++i2) {
            tsb[i2] = i2 + 1;
        }
        int r = ta.length;
        int c = tb.length;
        for (i = 0; i < a.length; ++i) {
            ta[i][0] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            tb[i][0] = b[i];
        }
        double[][] D = new double[r + 1][c + 1];
        double[] Di1 = new double[r + 1];
        double[] Dj1 = new double[c + 1];
        for (j = 1; j <= c; ++j) {
            double distj1 = 0.0;
            for (k = 0; k < dim; ++k) {
                if (j > 1) {
                    distj1 += (tb[j - 2][k] - tb[j - 1][k]) * (tb[j - 2][k] - tb[j - 1][k]);
                    continue;
                }
                distj1 += tb[j - 1][k] * tb[j - 1][k];
            }
            Dj1[j] = distj1;
        }
        for (i = 1; i <= r; ++i) {
            double disti1 = 0.0;
            for (k = 0; k < dim; ++k) {
                if (i > 1) {
                    disti1 += (ta[i - 2][k] - ta[i - 1][k]) * (ta[i - 2][k] - ta[i - 1][k]);
                    continue;
                }
                disti1 += ta[i - 1][k] * ta[i - 1][k];
            }
            Di1[i] = disti1;
            for (j = 1; j <= c; ++j) {
                dist = 0.0;
                for (k = 0; k < dim; ++k) {
                    dist += (ta[i - 1][k] - tb[j - 1][k]) * (ta[i - 1][k] - tb[j - 1][k]);
                    if (i <= 1 || j <= 1) continue;
                    dist += (ta[i - 2][k] - tb[j - 2][k]) * (ta[i - 2][k] - tb[j - 2][k]);
                }
                D[i][j] = dist;
            }
        }
        D[0][0] = 0.0;
        for (i = 1; i <= r; ++i) {
            D[i][0] = D[i - 1][0] + Di1[i];
        }
        for (j = 1; j <= c; ++j) {
            D[0][j] = D[0][j - 1] + Dj1[j];
        }
        for (i = 1; i <= r; ++i) {
            for (j = 1; j <= c; ++j) {
                double dist0;
                double dmin;
                double htrans = Math.abs(tsa[i - 1] - tsb[j - 1]);
                if (j > 1 && i > 1) {
                    htrans += Math.abs(tsa[i - 2] - tsb[j - 2]);
                }
                if ((dmin = (dist0 = D[i - 1][j - 1] + this.nu * htrans + D[i][j])) > (dist = Di1[i] + D[i - 1][j] + this.lambda + this.nu * (htrans = i > 1 ? tsa[i - 1] - tsa[i - 2] : tsa[i - 1]))) {
                    dmin = dist;
                }
                if (dmin > (dist = Dj1[j] + D[i][j - 1] + this.lambda + this.nu * (htrans = j > 1 ? tsb[j - 1] - tsb[j - 2] : tsb[j - 1]))) {
                    dmin = dist;
                }
                D[i][j] = dmin;
            }
        }
        dist = D[r][c];
        return dist;
    }

    public double distance(double[] first, double[] second, double cutOffValue) {
        return this.TWE_Distance(first, second);
    }
}

