/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import timeseriesweka.elastic_distance_measures.BasicDTW;

public class SakoeChibaDTW
extends BasicDTW {
    private double bandPercent;

    public SakoeChibaDTW(double bandPercent) throws IllegalArgumentException {
        this.setup(bandPercent);
    }

    private void setup(double bandPercent) throws IllegalArgumentException {
        if (bandPercent < 0.0 || bandPercent > 1.0) {
            throw new IllegalArgumentException("Band Size must be between 0 and 1");
        }
        this.bandPercent = bandPercent;
    }

    public int calculateBandSize(int instanceLength) {
        if (this.bandPercent == 0.0) {
            return 1;
        }
        double width = (double)instanceLength * this.bandPercent;
        return (int)Math.ceil(width);
    }

    @Override
    public double distance(double[] first, double[] second, double cutOffValue) {
        int i;
        int bandSize = this.calculateBandSize(first.length);
        this.distances = new double[first.length][second.length];
        this.distances[0][0] = (first[0] - second[0]) * (first[0] - second[0]);
        for (i = 1; i < second.length; ++i) {
            this.distances[0][i] = i < bandSize ? this.distances[0][i - 1] + (first[0] - second[i]) * (first[0] - second[i]) : Double.MAX_VALUE;
        }
        for (i = 1; i < first.length; ++i) {
            this.distances[i][0] = i < bandSize ? this.distances[i - 1][0] + (first[i] - second[0]) * (first[i] - second[0]) : Double.MAX_VALUE;
        }
        for (int i2 = 1; i2 < first.length; ++i2) {
            boolean overFlow = true;
            for (int j = 1; j < second.length; ++j) {
                if (i2 < j + bandSize && j < i2 + bandSize) {
                    double minDistance = Math.min(this.distances[i2][j - 1], Math.min(this.distances[i2 - 1][j], this.distances[i2 - 1][j - 1]));
                    this.distances[i2][j] = minDistance + (first[i2] - second[j]) * (first[i2] - second[j]);
                } else {
                    this.distances[i2][j] = Double.MAX_VALUE;
                }
                if (!overFlow || !(this.distances[i2][j] < cutOffValue)) continue;
                overFlow = false;
            }
            if (!overFlow) continue;
            return Double.MAX_VALUE;
        }
        return this.distances[first.length - 1][second.length - 1];
    }

    public void setBandSize(int bandSize) throws IllegalArgumentException {
        this.setup(bandSize);
    }

    public double getBandPercentage() {
        return this.bandPercent;
    }

    @Override
    public String toString() {
        return "SakoeChibaDTW{ bandSize=" + this.bandPercent + "}";
    }
}

