/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.neighboursearch.PerformanceStats;

public class MSMDistance
extends EuclideanDistance {
    double c = 0.1;

    public MSMDistance() {
        this.m_DontNormalize = true;
    }

    public MSMDistance(double c) {
        this.m_DontNormalize = true;
        this.c = c;
    }

    public void setC(double v) {
        this.c = v;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] arr2;
        int secondClassIndex;
        double[] arr1;
        int firtClassIndex = first.classIndex();
        if (firtClassIndex > 0) {
            arr1 = new double[first.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < first.numAttributes(); ++i) {
                if (i == firtClassIndex) continue;
                arr1[j] = first.value(i);
                ++j;
            }
        } else {
            arr1 = first.toDoubleArray();
        }
        if ((secondClassIndex = second.classIndex()) > 0) {
            arr2 = new double[second.numAttributes() - 1];
            int j = 0;
            for (int i = 0; i < second.numAttributes(); ++i) {
                if (i == secondClassIndex) continue;
                arr2[j] = second.value(i);
                ++j;
            }
        } else {
            arr2 = second.toDoubleArray();
        }
        return this.distance(arr1, arr2, cutOffValue);
    }

    public double MSM_Distance(double[] a, double[] b) {
        int j;
        int i;
        int m = a.length;
        int n = b.length;
        double[][] cost = new double[m][n];
        cost[0][0] = Math.abs(a[0] - b[0]);
        for (i = 1; i < m; ++i) {
            cost[i][0] = cost[i - 1][0] + this.editCost(a[i], a[i - 1], b[0]);
        }
        for (j = 1; j < n; ++j) {
            cost[0][j] = cost[0][j - 1] + this.editCost(b[j], a[0], b[j - 1]);
        }
        for (i = 1; i < m; ++i) {
            for (j = 1; j < n; ++j) {
                double d1 = cost[i - 1][j - 1] + Math.abs(a[i] - b[j]);
                double d2 = cost[i - 1][j] + this.editCost(a[i], a[i - 1], b[j]);
                double d3 = cost[i][j - 1] + this.editCost(b[j], a[i], b[j - 1]);
                cost[i][j] = Math.min(d1, Math.min(d2, d3));
            }
        }
        return cost[m - 1][n - 1];
    }

    public double editCost(double new_point, double x, double y) {
        double dist = 0.0;
        dist = x <= new_point && new_point <= y || y <= new_point && new_point <= x ? this.c : this.c + Math.min(Math.abs(new_point - x), Math.abs(new_point - y));
        return dist;
    }

    public double distance(double[] first, double[] second, double cutOffValue) {
        return this.MSM_Distance(first, second);
    }
}

