/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.neighboursearch.PerformanceStats;

public class DTW_DistanceBasic
extends EuclideanDistance {
    private static final long serialVersionUID = 1L;
    protected int windowSize;
    protected double r = 1.0;
    protected double[][] matrixD;
    protected int endX = 0;
    protected int endY = 0;

    public DTW_DistanceBasic() {
        this.m_DontNormalize = true;
    }

    public DTW_DistanceBasic(Instances data) {
        super(data);
        this.m_DontNormalize = true;
    }

    @Override
    public double distance(Instance first, Instance second) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, null, false);
    }

    @Override
    public double distance(Instance first, Instance second, PerformanceStats stats) {
        return this.distance(first, second, Double.POSITIVE_INFINITY, stats, false);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats) {
        return this.distance(first, second, cutOffValue, stats, false);
    }

    public double distance(Instance first, Instance second, double cutOffValue, PerformanceStats stats, boolean print) {
        return this.distance(first, second, cutOffValue);
    }

    private double[] extractSeries(Instance a) {
        double[] s;
        int fClass = a.classIndex();
        if (fClass > 0) {
            s = new double[a.numAttributes() - 1];
            int count = 0;
            for (int i = 0; i < s.length + 1; ++i) {
                if (i == fClass) continue;
                s[count] = a.value(i);
                ++count;
            }
        } else {
            s = a.toDoubleArray();
        }
        return s;
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        double[] f = this.extractSeries(first);
        double[] s = this.extractSeries(second);
        return this.distance(f, s, cutOffValue);
    }

    public double distance(double[] a, double[] b, double cutoff) {
        int j;
        int i;
        boolean tooBig = true;
        if (a.length < b.length) {
            double[] temp = a;
            a = b;
            b = temp;
        }
        int n = a.length;
        int m = b.length;
        this.matrixD = new double[n][n];
        this.windowSize = this.getWindowSize(n);
        for (i = 0; i < n; ++i) {
            for (j = 0; j < m; ++j) {
                this.matrixD[i][j] = Double.MAX_VALUE;
            }
        }
        this.matrixD[0][0] = (a[0] - b[0]) * (a[0] - b[0]);
        for (int j2 = 1; j2 < this.windowSize && j2 < n; ++j2) {
            this.matrixD[0][j2] = this.matrixD[0][j2 - 1] + (a[0] - b[j2]) * (a[0] - b[j2]);
        }
        for (i = 1; i < this.windowSize && i < n; ++i) {
            this.matrixD[i][0] = this.matrixD[i - 1][0] + (a[i] - b[0]) * (a[i] - b[0]);
        }
        for (i = 1; i < n; ++i) {
            tooBig = true;
            for (j = 1; j < m; ++j) {
                if (i >= j + this.windowSize || j >= i + this.windowSize) continue;
                double minDist = this.matrixD[i][j - 1];
                if (this.matrixD[i - 1][j] < minDist) {
                    minDist = this.matrixD[i - 1][j];
                }
                if (this.matrixD[i - 1][j - 1] < minDist) {
                    minDist = this.matrixD[i - 1][j - 1];
                }
                this.matrixD[i][j] = minDist + (a[i] - b[j]) * (a[i] - b[j]);
                if (!tooBig || !(this.matrixD[i][j] < cutoff)) continue;
                tooBig = false;
            }
            if (!tooBig) continue;
            return Double.MAX_VALUE;
        }
        return this.matrixD[n - 1][m - 1];
    }

    public static int findWindowSize(double rr, int n) {
        int w = (int)(rr * (double)n);
        if (w < 1) {
            w = 1;
        } else if (w < n) {
            ++w;
        }
        return w;
    }

    public final int getWindowSize(int n) {
        int w = (int)(this.r * (double)n);
        if (w < 1) {
            w = 1;
        } else if (w < n) {
            ++w;
        }
        return w;
    }

    public final int findMaxWindow() {
        int n = this.matrixD.length;
        int m = this.matrixD[0].length;
        int x = n - 1;
        int y = m - 1;
        int maxDiff = 0;
        while (x > 0 && y > 0) {
            int diff;
            double min = this.matrixD[x - 1][y - 1];
            if (min <= this.matrixD[x - 1][y] && min <= this.matrixD[x][y - 1]) {
                --x;
                --y;
            } else if (this.matrixD[x - 1][y] < this.matrixD[x][y - 1]) {
                --x;
            } else {
                --y;
            }
            if ((diff = x > y ? x - y : y - x) <= maxDiff) continue;
            maxDiff = diff;
        }
        return maxDiff;
    }

    void printPath() {
        int n = this.matrixD.length;
        int m = this.matrixD[0].length;
        int x = n - 1;
        int y = m - 1;
        int count = 0;
        System.out.println(count + "END  Point  = " + x + "," + y + " value =" + this.matrixD[x][y]);
        while (x > 0 && y > 0) {
            double min = this.matrixD[x - 1][y - 1];
            if (min <= this.matrixD[x - 1][y] && min <= this.matrixD[x][y - 1]) {
                --x;
                --y;
            } else if (this.matrixD[x - 1][y] < this.matrixD[x][y - 1]) {
                --x;
            } else {
                --y;
            }
            System.out.println(++count + " Point  = " + x + "," + y + " value =" + this.matrixD[x][y]);
        }
        while (x > 0) {
            System.out.println(count + " Point  = " + --x + "," + y + " value =" + this.matrixD[x][y]);
        }
        while (y > 0) {
            System.out.println(count + " Point  = " + x + "," + --y + " value =" + this.matrixD[x][y]);
        }
    }

    @Override
    public String toString() {
        return "DTW BASIC. r=" + this.r;
    }

    @Override
    public String globalInfo() {
        return " DTW Basic Distance";
    }

    @Override
    public String getRevision() {
        return "Version 1.0";
    }

    public void setR(double x) {
        this.r = x;
    }

    public double getR() {
        return this.r;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public static void main(String[] args) {
        int i;
        System.out.println(" Very basic test for DTW distance");
        double[] a = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] b = new double[]{2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        for (i = 0; i < a.length; ++i) {
            System.out.print(a[i] + ",");
        }
        System.out.println("\n************");
        for (i = 0; i < b.length; ++i) {
            System.out.print(b[i] + ",");
        }
        System.out.println("\n Euclidean distance is 8, DTW should be 2");
        DTW_DistanceBasic dtw = new DTW_DistanceBasic();
    }
}

