/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.elastic_distance_measures;

import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;

public final class DTW
extends DTW_DistanceBasic {
    @Override
    public final double distance(double[] a, double[] b, double cutoff) {
        int j;
        int end;
        int start;
        int i;
        if (a.length < b.length) {
            double[] temp = a;
            a = b;
            b = temp;
        }
        int n = a.length;
        int m = b.length;
        this.windowSize = this.getWindowSize(n);
        if (this.matrixD == null) {
            this.matrixD = new double[n][m];
        }
        for (i = 0; i < n; ++i) {
            start = this.windowSize < i ? i - this.windowSize : 0;
            end = i + this.windowSize + 1 < m ? i + this.windowSize + 1 : m;
            for (j = start; j < end; ++j) {
                this.matrixD[i][j] = Double.MAX_VALUE;
            }
        }
        this.matrixD[0][0] = (a[0] - b[0]) * (a[0] - b[0]);
        for (int j2 = 1; j2 < this.windowSize && j2 < m; ++j2) {
            this.matrixD[0][j2] = this.matrixD[0][j2 - 1] + (a[0] - b[j2]) * (a[0] - b[j2]);
        }
        for (i = 1; i < this.windowSize && i < n; ++i) {
            this.matrixD[i][0] = this.matrixD[i - 1][0] + (a[i] - b[0]) * (a[i] - b[0]);
        }
        for (i = 1; i < n; ++i) {
            boolean tooBig = true;
            start = this.windowSize < i ? i - this.windowSize + 1 : 1;
            end = i + this.windowSize < m ? i + this.windowSize : m;
            for (j = start; j < end; ++j) {
                double minDist = this.matrixD[i][j - 1];
                if (this.matrixD[i - 1][j] < minDist) {
                    minDist = this.matrixD[i - 1][j];
                }
                if (this.matrixD[i - 1][j - 1] < minDist) {
                    minDist = this.matrixD[i - 1][j - 1];
                }
                this.matrixD[i][j] = minDist + (a[i] - b[j]) * (a[i] - b[j]);
                if (!tooBig || !(this.matrixD[i][j] < cutoff)) continue;
                tooBig = false;
            }
            if (!tooBig) continue;
            return Double.MAX_VALUE;
        }
        return this.matrixD[n - 1][m - 1];
    }
}

