/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class RecallByClass
extends ModuleWeightingScheme {
    public RecallByClass() {
        this.uniformWeighting = false;
        this.needTrainPreds = true;
    }

    @Override
    protected double[] defineWeighting(EnsembleModule module, int numClasses) {
        double[] weights = new double[numClasses];
        for (int c = 0; c < numClasses; ++c) {
            weights[c] = this.computeRecall(module.trainResults.confusionMatrix, c);
        }
        return weights;
    }

    protected double computeRecall(double[][] confMat, int c) {
        double tp = confMat[c][c];
        if (tp == 0.0) {
            return 1.0E-7;
        }
        double fn = 0.0;
        for (int i = 0; i < confMat.length; ++i) {
            if (i == c) continue;
            fn += confMat[c][i];
        }
        double recall = tp / (tp + fn);
        return recall;
    }
}

