/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.weightings;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.weightings.ModuleWeightingScheme;

public class MCCWeighting
extends ModuleWeightingScheme {
    private double power = 1.0;

    public MCCWeighting() {
        this.uniformWeighting = true;
    }

    public MCCWeighting(double power) {
        this.power = power;
        this.uniformWeighting = true;
    }

    public double getPower() {
        return this.power;
    }

    public void setPower(double power) {
        this.power = power;
    }

    @Override
    public double[] defineWeighting(EnsembleModule module, int numClasses) {
        double weight = (module.trainResults.mcc + 1.0) / 2.0;
        return this.makeUniformWeighting(Math.pow(weight, this.power), numClasses);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + (this.power == 1.0 ? "" : "(" + this.power + ")");
    }
}

