/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting.stacking;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.stacking.AbstractStacking;
import weka.classifiers.Classifier;
import weka.core.DenseInstance;
import weka.core.Instance;

public class StackingOnDists
extends AbstractStacking {
    public StackingOnDists(Classifier classifier) {
        super(classifier);
    }

    public StackingOnDists(Classifier classifier, int numClasses) {
        super(classifier, numClasses);
    }

    @Override
    protected void setNumOutputAttributes(EnsembleModule[] modules) {
        this.numOutputAtts = modules.length * this.numClasses + 1;
    }

    @Override
    protected Instance buildInst(double[][] dists, Double classVal) {
        double[] instData = new double[this.numOutputAtts];
        int i = 0;
        for (int m = 0; m < dists.length; ++m) {
            for (int c = 0; c < this.numClasses; ++c) {
                instData[i++] = dists[m][c];
            }
        }
        assert (i == this.numOutputAtts - 2);
        if (classVal != null) {
            instData[this.numOutputAtts - 1] = classVal;
        }
        this.instsHeader.add(new DenseInstance(1.0, instData));
        return this.instsHeader.remove(0);
    }
}

