/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.ModuleVotingScheme;
import weka.core.Instance;

public class MajorityVoteByCorrectedConfidence
extends ModuleVotingScheme {
    public MajorityVoteByCorrectedConfidence() {
    }

    public MajorityVoteByCorrectedConfidence(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public double[] distributionForTrainInstance(EnsembleModule[] modules, int trainInstanceIndex) {
        double[] preds = new double[this.numClasses];
        double normValue = 1.0 / (double)this.numClasses;
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            int n = pred = (int)modules[m].trainResults.getPredClassValue(trainInstanceIndex);
            preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * (modules[m].trainResults.getDistributionForInstance(trainInstanceIndex)[pred] - normValue);
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForTestInstance(EnsembleModule[] modules, int testInstanceIndex) {
        double[] preds = new double[this.numClasses];
        double normValue = 1.0 / (double)this.numClasses;
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            int n = pred = (int)modules[m].testResults.getPredClassValue(testInstanceIndex);
            preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * (modules[m].testResults.getDistributionForInstance(testInstanceIndex)[pred] - normValue);
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForInstance(EnsembleModule[] modules, Instance testInstance) throws Exception {
        double[] preds = new double[this.numClasses];
        double normValue = 1.0 / (double)this.numClasses;
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            double[] dist = modules[m].getClassifier().distributionForInstance(testInstance);
            this.storeModuleTestResult(modules[m], dist);
            int n = pred = (int)this.indexOfMax(dist);
            preds[n] = preds[n] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * (dist[pred] - normValue);
        }
        return this.normalise(preds);
    }
}

