/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.BestIndividual;

public class BestIndividualTrain
extends BestIndividual {
    public BestIndividualTrain() {
    }

    public BestIndividualTrain(int numClasses) {
        super(numClasses);
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) throws Exception {
        super.trainVotingScheme(modules, numClasses);
        double bestWeight = -1.0;
        for (int m = 0; m < modules.length; ++m) {
            double prevWeight = modules[m].posteriorWeights[0];
            for (int c = 1; c < numClasses; ++c) {
                if (prevWeight != modules[m].posteriorWeights[c]) {
                    throw new Exception("BestIndividualTrain cannot be used with non-uniform weighting schemes");
                }
                prevWeight = modules[m].posteriorWeights[c];
            }
            if (!(modules[m].posteriorWeights[0] > bestWeight)) continue;
            bestWeight = modules[m].posteriorWeights[0];
            this.bestModule = m;
        }
        this.bestModulesInds.add(this.bestModule);
        this.bestModulesNames.add(modules[this.bestModule].getModuleName());
        this.printlnDebug(modules[this.bestModule].getModuleName());
    }
}

