/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.voting;

import timeseriesweka.classifiers.ensembles.EnsembleModule;
import timeseriesweka.classifiers.ensembles.voting.ModuleVotingScheme;
import weka.core.Instance;

public class AverageVoteByConfidence
extends ModuleVotingScheme {
    public AverageVoteByConfidence() {
    }

    public AverageVoteByConfidence(int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public void trainVotingScheme(EnsembleModule[] modules, int numClasses) {
        this.numClasses = numClasses;
    }

    @Override
    public double[] distributionForTrainInstance(EnsembleModule[] modules, int trainInstanceIndex) {
        double[] preds = new double[this.numClasses];
        int[] numPredsForClass = new int[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            int n = pred = (int)modules[m].trainResults.getPredClassValue(trainInstanceIndex);
            numPredsForClass[n] = numPredsForClass[n] + 1;
            double[] p = modules[m].trainResults.getDistributionForInstance(trainInstanceIndex);
            int n2 = pred;
            preds[n2] = preds[n2] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * p[pred];
        }
        for (int c = 0; c < this.numClasses; ++c) {
            if (numPredsForClass[c] == 0) continue;
            int n = c;
            preds[n] = preds[n] / (double)numPredsForClass[c];
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForTestInstance(EnsembleModule[] modules, int testInstanceIndex) {
        double[] preds = new double[this.numClasses];
        int[] numPredsForClass = new int[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            int n = pred = (int)modules[m].testResults.getPredClassValue(testInstanceIndex);
            numPredsForClass[n] = numPredsForClass[n] + 1;
            double[] p = modules[m].testResults.getDistributionForInstance(testInstanceIndex);
            int n2 = pred;
            preds[n2] = preds[n2] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * p[pred];
        }
        for (int c = 0; c < this.numClasses; ++c) {
            if (numPredsForClass[c] == 0) continue;
            int n = c;
            preds[n] = preds[n] / (double)numPredsForClass[c];
        }
        return this.normalise(preds);
    }

    @Override
    public double[] distributionForInstance(EnsembleModule[] modules, Instance testInstance) throws Exception {
        double[] preds = new double[this.numClasses];
        int[] numPredsForClass = new int[this.numClasses];
        for (int m = 0; m < modules.length; ++m) {
            int pred;
            double[] dist = modules[m].getClassifier().distributionForInstance(testInstance);
            this.storeModuleTestResult(modules[m], dist);
            int n = pred = (int)this.indexOfMax(dist);
            numPredsForClass[n] = numPredsForClass[n] + 1;
            int n2 = pred;
            preds[n2] = preds[n2] + modules[m].priorWeight * modules[m].posteriorWeights[pred] * dist[pred];
        }
        for (int c = 0; c < this.numClasses; ++c) {
            if (numPredsForClass[c] == 0) continue;
            int n = c;
            preds[n] = preds[n] / (double)numPredsForClass[c];
        }
        return this.normalise(preds);
    }
}

