/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.ensembles.elastic_ensemble;

import timeseriesweka.classifiers.ensembles.elastic_ensemble.Efficient1NN;
import timeseriesweka.elastic_distance_measures.LCSSDistance;
import utilities.ClassifierTools;
import weka.classifiers.lazy.kNN;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class LCSS1NN
extends Efficient1NN {
    private int delta;
    private double epsilon;
    boolean epsilonsAndDeltasRefreshed;
    double[] epsilons;
    int[] deltas;

    public LCSS1NN(int delta, double epsilon) {
        this.delta = delta;
        this.epsilon = epsilon;
        this.epsilonsAndDeltasRefreshed = false;
        this.classifierIdentifier = "LCSS_1NN";
        this.allowLoocv = false;
    }

    public LCSS1NN() {
        this.delta = 3;
        this.epsilon = 1.0;
        this.epsilonsAndDeltasRefreshed = false;
        this.classifierIdentifier = "LCSS_1NN";
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        super.buildClassifier(train);
        this.epsilonsAndDeltasRefreshed = false;
    }

    public double distance(Instance first, Instance second) {
        if (first.classIndex() != first.numAttributes() - 1 || second.classIndex() != second.numAttributes() - 1) {
            System.err.println("Warning: class designed to use problems with class index as last attribute. Defaulting to original MSM distance");
            return new LCSSDistance(this.delta, this.epsilon).distance(first, second);
        }
        int m = first.numAttributes() - 1;
        int n = second.numAttributes() - 1;
        int[][] lcss = new int[m + 1][n + 1];
        for (int i = 0; i < m; ++i) {
            for (int j = i - this.delta; j <= i + this.delta; ++j) {
                if (j < 0) {
                    j = -1;
                    continue;
                }
                if (j >= n) {
                    j = i + this.delta;
                    continue;
                }
                lcss[i + 1][j + 1] = second.value(j) + this.epsilon >= first.value(i) && second.value(j) - this.epsilon <= first.value(i) ? lcss[i][j] + 1 : (lcss[i][j + 1] > lcss[i + 1][j] ? lcss[i][j + 1] : lcss[i + 1][j]);
            }
        }
        int max = -1;
        for (int i = 1; i < lcss[lcss.length - 1].length; ++i) {
            if (lcss[lcss.length - 1][i] <= max) continue;
            max = lcss[lcss.length - 1][i];
        }
        return 1.0 - (double)max / (double)m;
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 10; ++i) {
            LCSS1NN.runComparison();
        }
    }

    public static void runComparison() throws Exception {
        double pred;
        int i;
        String tscProbDir = "C:/users/sjx07ngu/Dropbox/TSC Problems/";
        String datasetName = "GunPoint";
        Instances train = ClassifierTools.loadData(tscProbDir + datasetName + "/" + datasetName + "_TRAIN");
        Instances test = ClassifierTools.loadData(tscProbDir + datasetName + "/" + datasetName + "_TEST");
        int delta = 10;
        double epsilon = 0.5;
        kNN knn = new kNN();
        LCSSDistance lcssOld = new LCSSDistance(delta, epsilon);
        knn.setDistanceFunction(lcssOld);
        knn.buildClassifier(train);
        LCSS1NN lcssNew = new LCSS1NN(delta, epsilon);
        lcssNew.buildClassifier(train);
        int correctOld = 0;
        int correctNew = 0;
        long start = System.nanoTime();
        correctOld = 0;
        for (i = 0; i < test.numInstances(); ++i) {
            pred = knn.classifyInstance(test.instance(i));
            if (pred != test.instance(i).classValue()) continue;
            ++correctOld;
        }
        long end = System.nanoTime();
        long oldTime = end - start;
        start = System.nanoTime();
        correctNew = 0;
        for (i = 0; i < test.numInstances(); ++i) {
            pred = lcssNew.classifyInstance(test.instance(i));
            if (pred != test.instance(i).classValue()) continue;
            ++correctNew;
        }
        end = System.nanoTime();
        long newTime = end - start;
        System.out.println("Comparison of MSM: " + datasetName);
        System.out.println("==========================================");
        System.out.println("Old acc:    " + (double)correctOld / (double)test.numInstances());
        System.out.println("New acc:    " + (double)correctNew / (double)test.numInstances());
        System.out.println("Old timing: " + oldTime);
        System.out.println("New timing: " + newTime);
        System.out.println("Relative Performance: " + (double)newTime / (double)oldTime);
    }

    @Override
    public double distance(Instance first, Instance second, double cutOffValue) {
        return this.distance(first, second);
    }

    @Override
    public void setParamsFromParamId(Instances train, int paramId) {
        if (!this.epsilonsAndDeltasRefreshed) {
            double stdTrain = LCSSDistance.stdv_p(train);
            double stdFloor = stdTrain * 0.2;
            this.epsilons = LCSSDistance.getInclusive10(stdFloor, stdTrain);
            this.deltas = LCSSDistance.getInclusive10(0, (train.numAttributes() - 1) / 4);
            this.epsilonsAndDeltasRefreshed = true;
        }
        this.delta = this.deltas[paramId / 10];
        this.epsilon = this.epsilons[paramId % 10];
    }

    @Override
    public String getParamInformationString() {
        return this.delta + "," + this.epsilon;
    }
}

