/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import fileIO.OutFile;
import java.util.ArrayList;
import java.util.HashMap;
import timeseriesweka.classifiers.ParameterSplittable;
import timeseriesweka.elastic_distance_measures.DTW;
import timeseriesweka.elastic_distance_measures.DTW_DistanceBasic;
import utilities.ClassifierResults;
import utilities.ClassifierTools;
import utilities.SaveParameterInfo;
import utilities.TrainAccuracyEstimate;
import vector_classifiers.SaveEachParameter;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class SlowDTW_1NN
extends AbstractClassifier
implements SaveParameterInfo,
TrainAccuracyEstimate,
SaveEachParameter,
ParameterSplittable {
    private boolean optimiseWindow = false;
    private double windowSize = 1.0;
    private int maxPercentageWarp = 100;
    private Instances train;
    private int trainSize;
    private int bestWarp;
    private int maxWindowSize;
    DTW_DistanceBasic dtw;
    HashMap<Integer, Double> distances;
    double maxR = 1.0;
    ArrayList<Double> accuracy = new ArrayList();
    String trainPath;
    protected String resultsPath;
    protected boolean saveEachParaAcc = false;
    private ClassifierResults res = new ClassifierResults();

    @Override
    public void setPathToSaveParameters(String r) {
        this.resultsPath = r;
        this.setSaveEachParaAcc(true);
    }

    @Override
    public void setSaveEachParaAcc(boolean b) {
        this.saveEachParaAcc = b;
    }

    @Override
    public void writeCVTrainToFile(String train) {
        this.trainPath = train;
    }

    @Override
    public ClassifierResults getTrainResults() {
        return this.res;
    }

    @Override
    public String getParas() {
        return this.getParameters();
    }

    @Override
    public double getAcc() {
        return this.res.acc;
    }

    public SlowDTW_1NN() {
        this.dtw = new DTW();
        this.accuracy = new ArrayList();
    }

    public SlowDTW_1NN(DTW_DistanceBasic d) {
        this.dtw = d;
        this.accuracy = new ArrayList();
    }

    @Override
    public String getParameters() {
        String result = "BuildTime," + this.res.buildTime + ",CVAcc," + this.res.acc + ",Memory," + this.res.memory;
        result = result + ",BestWarpPercent," + this.bestWarp + ",AllAccs,";
        for (double d : this.accuracy) {
            result = result + "," + d;
        }
        return result;
    }

    public double getMaxR() {
        return this.maxR;
    }

    public void setMaxPercentageWarp(int a) {
        this.maxPercentageWarp = a;
    }

    public void optimiseWindow(boolean b) {
        this.optimiseWindow = b;
    }

    public void setR(double r) {
        this.dtw.setR(r);
    }

    public double getR() {
        return this.dtw.getR();
    }

    public int getBestWarp() {
        return this.bestWarp;
    }

    public int getWindowSize() {
        return this.dtw.getWindowSize(this.train.numAttributes() - 1);
    }

    @Override
    public void buildClassifier(Instances d) {
        long usedBytes;
        this.res = new ClassifierResults();
        long t = System.currentTimeMillis();
        this.train = d;
        this.trainSize = d.numInstances();
        if (this.optimiseWindow) {
            this.maxR = 0.0;
            double maxAcc = 0.0;
            int dataLength = this.train.numAttributes() - 1;
            for (int i = this.maxPercentageWarp; i >= 0; --i) {
                this.dtw.setR((double)i / 100.0);
                double acc = this.crossValidateAccuracy(maxAcc);
                this.accuracy.add(acc);
                if (!(acc > maxAcc)) continue;
                this.maxR = i;
                maxAcc = acc;
            }
            this.bestWarp = (int)(this.maxR * (double)dataLength / 100.0);
            System.out.println("OPTIMAL WINDOW =" + this.maxR + " % which gives a warp of" + this.bestWarp + " data");
            this.dtw.setR(this.maxR / 100.0);
            this.res.acc = maxAcc;
        }
        this.res.buildTime = System.currentTimeMillis() - t;
        Runtime rt = Runtime.getRuntime();
        this.res.memory = usedBytes = rt.totalMemory() - rt.freeMemory();
        if (this.trainPath != null && this.trainPath != "") {
            OutFile f = new OutFile(this.trainPath);
            f.writeLine(this.train.relationName() + ",FastDTW_1NN,Train");
            f.writeLine(this.getParameters());
            f.writeLine(this.res.acc + "");
            for (int i = 0; i < this.train.numInstances(); ++i) {
                Instance test = this.train.remove(i);
                int pred = (int)this.classifyInstance(test);
                f.writeString((int)test.classValue() + "," + pred + ",");
                for (int j = 0; j < this.train.numClasses(); ++j) {
                    if (j == pred) {
                        f.writeString(",1");
                        continue;
                    }
                    f.writeString(",0");
                }
                f.writeString("\n");
                this.train.add(i, test);
            }
        }
    }

    @Override
    public double classifyInstance(Instance d) {
        double minSoFar = Double.MAX_VALUE;
        int index = 0;
        for (int i = 0; i < this.train.numInstances(); ++i) {
            double dist = this.dtw.distance(this.train.instance(i), d, minSoFar);
            if (!(dist < minSoFar)) continue;
            minSoFar = dist;
            index = i;
        }
        return this.train.instance(index).classValue();
    }

    @Override
    public double[] distributionForInstance(Instance instance) {
        double[] dist = new double[instance.numClasses()];
        dist[(int)this.classifyInstance((Instance)instance)] = 1.0;
        return dist;
    }

    private double crossValidateAccuracy(double maxAcc) {
        double a = 0.0;
        int bestNosCorrect = (int)(maxAcc * (double)this.trainSize);
        this.maxWindowSize = 0;
        this.distances = new HashMap(this.trainSize);
        for (int i = 0; i < this.trainSize; ++i) {
            int nearest = 0;
            double minDist = Double.MAX_VALUE;
            Instance inst = this.train.instance(i);
            for (int j = 0; j < this.trainSize; ++j) {
                double d;
                if (i == j) continue;
                if (j > i) {
                    d = this.dtw.distance(inst, this.train.instance(j), minDist);
                    if (d != Double.MAX_VALUE) {
                        this.distances.put(i * this.trainSize + j, d);
                    }
                } else {
                    d = this.distances.containsKey(j * this.trainSize + i) ? this.distances.get(j * this.trainSize + i).doubleValue() : this.dtw.distance(inst, this.train.instance(j), minDist);
                }
                if (!(d < minDist)) continue;
                nearest = j;
                minDist = d;
                int w = this.dtw.findMaxWindow();
                if (w <= this.maxWindowSize) continue;
                this.maxWindowSize = w;
            }
            if (inst.classValue() != this.train.instance(nearest).classValue()) continue;
            a += 1.0;
        }
        return a / (double)this.trainSize;
    }

    public static void main(String[] args) {
        SlowDTW_1NN c = new SlowDTW_1NN();
        String path = "C:\\Research\\Data\\Time Series Data\\Time Series Classification\\";
        Instances test = ClassifierTools.loadData(path + "Coffee\\Coffee_TEST.arff");
        Instances train = ClassifierTools.loadData(path + "Coffee\\Coffee_TRAIN.arff");
        train.setClassIndex(train.numAttributes() - 1);
        c.buildClassifier(train);
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setParamSearch(boolean b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setParametersFromIndex(int x) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

