/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import java.util.ArrayList;
import java.util.Random;
import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.classifiers.ElasticEnsemble;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.PowerSpectrum;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransform;
import timeseriesweka.filters.shapelet_transforms.ShapeletTransformTimingUtilities;
import utilities.ClassifierTools;
import vector_classifiers.CAWPE;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class FlatCote
extends AbstractClassifierWithTrainingData {
    private Instances train;
    private ElasticEnsemble ee;
    private CAWPE st;
    private CAWPE acf;
    private CAWPE ps;
    private double[][] cvAccs;
    private double cvSum;
    private double[] weightByClass;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "A. Bagnall and J. Lines and J. Hills and A. Bostrom");
        result.setValue(TechnicalInformation.Field.TITLE, "Time-Series Classification with COTE: The Collective of Transformation-Based Ensembles");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.VOLUME, "27");
        result.setValue(TechnicalInformation.Field.NUMBER, "9");
        result.setValue(TechnicalInformation.Field.PAGES, "2522-2535");
        result.setValue(TechnicalInformation.Field.YEAR, "2015");
        return result;
    }

    @Override
    public void buildClassifier(Instances train) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        this.train = train;
        this.ee = new ElasticEnsemble();
        this.ee.buildClassifier(train);
        ShapeletTransform shapeletTransform = ShapeletTransformTimingUtilities.createTransformWithTimeLimit(train, 24.0);
        shapeletTransform.supressOutput();
        this.st = new CAWPE();
        this.st.setTransform(shapeletTransform);
        this.st.buildClassifier(train);
        this.acf = new CAWPE();
        this.acf.setTransform(new ACF());
        this.acf.buildClassifier(train);
        this.ps = new CAWPE();
        this.ps.setTransform(new PowerSpectrum());
        this.ps.buildClassifier(train);
        this.cvAccs = new double[4][];
        this.cvAccs[0] = this.ee.getCVAccs();
        this.cvAccs[1] = this.st.getIndividualCvAccs();
        this.cvAccs[2] = this.acf.getIndividualCvAccs();
        this.cvAccs[3] = this.ps.getIndividualCvAccs();
        this.cvSum = 0.0;
        for (int e = 0; e < this.cvAccs.length; ++e) {
            for (int c = 0; c < this.cvAccs[e].length; ++c) {
                this.cvSum += this.cvAccs[e][c];
            }
        }
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public double[] distributionForInstance(Instance test) throws Exception {
        this.weightByClass = null;
        this.classifyInstance(test);
        double[] dists = new double[this.weightByClass.length];
        for (int c = 0; c < this.weightByClass.length; ++c) {
            dists[c] = this.weightByClass[c] / this.cvSum;
        }
        return dists;
    }

    @Override
    public double classifyInstance(Instance test) throws Exception {
        double[][] preds = new double[][]{this.ee.classifyInstanceByConstituents(test), this.st.classifyInstanceByConstituents(test), this.acf.classifyInstanceByConstituents(test), this.ps.classifyInstanceByConstituents(test)};
        this.weightByClass = new double[this.train.numClasses()];
        ArrayList<Double> bsfClassVals = new ArrayList<Double>();
        double bsfWeight = -1.0;
        for (int e = 0; e < preds.length; ++e) {
            for (int c = 0; c < preds[e].length; ++c) {
                int n = (int)preds[e][c];
                this.weightByClass[n] = this.weightByClass[n] + this.cvAccs[e][c];
                if (this.weightByClass[(int)preds[e][c]] > bsfWeight) {
                    bsfWeight = this.weightByClass[(int)preds[e][c]];
                    bsfClassVals = new ArrayList();
                    bsfClassVals.add(preds[e][c]);
                    continue;
                }
                if (!(this.weightByClass[(int)preds[e][c]] > bsfWeight)) continue;
                bsfClassVals.add(preds[e][c]);
            }
        }
        if (bsfClassVals.size() > 1) {
            return (Double)bsfClassVals.get(new Random().nextInt(bsfClassVals.size()));
        }
        return (Double)bsfClassVals.get(0);
    }

    public static void main(String[] args) throws Exception {
        FlatCote fc = new FlatCote();
        Instances train = ClassifierTools.loadData("C:/users/sjx07ngu/dropbox/tsc problems/ItalyPowerDemand/ItalyPowerDemand_TRAIN");
        Instances test = ClassifierTools.loadData("C:/users/sjx07ngu/dropbox/tsc problems/ItalyPowerDemand/ItalyPowerDemand_TEST");
        fc.buildClassifier(train);
        int correct = 0;
        for (int i = 0; i < test.numInstances(); ++i) {
            if (fc.classifyInstance(test.instance(i)) != test.instance(i).classValue()) continue;
            ++correct;
        }
        System.out.println("Acc");
        System.out.println(correct + "/" + test.numInstances());
        System.out.println((double)correct / (double)test.numInstances());
    }

    private static enum EnsembleType {
        EE,
        ST,
        ACF,
        PS;

    }
}

