/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.windowSearcher;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import timeseriesweka.classifiers.FastWWS.items.Itemset;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class WindowSearcher
extends AbstractClassifier {
    private static final long serialVersionUID = -1561497612657542978L;
    protected static int bestWarpingWindow;
    protected static int bestWindowPercent;
    protected static double bestScore;
    protected static String type;
    protected static String datasetName;
    protected static String resDir;
    public PrintStream out = System.out;
    protected boolean forwardSearch = false;
    protected boolean greedySearch = false;
    protected SymbolicSequence[] train;
    protected HashMap<String, ArrayList<SymbolicSequence>> classedData;
    protected HashMap<String, ArrayList<Integer>> classedDataIndices;
    protected String[] classMap;
    protected double[][] warpingMatrix;
    protected double[] U;
    protected double[] L;
    protected double[] U1;
    protected double[] L1;
    protected int maxLength;
    protected int maxWindow;
    protected String[] searchResults;
    protected int nParams = 100;
    private int[][] nns;
    private double[][] dist;

    public WindowSearcher() {
    }

    public WindowSearcher(String name) {
        datasetName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            this.classedData.get(clas).add(this.train[i]);
            this.classedDataIndices.get(clas).add(i);
        }
        this.warpingMatrix = new double[this.maxLength][this.maxLength];
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.nns = new int[this.maxWindow + 1][this.train.length];
        this.dist = new double[this.maxWindow + 1][this.train.length];
        this.searchBestWarpingWindow();
        if (bestWindowPercent < 0) {
            bestWindowPercent = this.lengthToPercent(bestWarpingWindow);
        }
        System.out.println("Windows found=" + bestWarpingWindow + "(" + bestWindowPercent + ") Best Acc=" + (1.0 - bestScore));
    }

    public void buildClassifierEstimate(Instances data, int estimate) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            this.classedData.get(clas).add(this.train[i]);
            this.classedDataIndices.get(clas).add(i);
        }
        this.warpingMatrix = new double[this.maxLength][this.maxLength];
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.searchResults = new String[this.maxWindow + 1];
        this.nns = new int[this.maxWindow + 1][this.train.length];
        this.dist = new double[this.maxWindow + 1][this.train.length];
        int[] nErrors = new int[this.maxWindow + 1];
        double[] score = new double[this.maxWindow + 1];
        double bestScore = Double.MAX_VALUE;
        bestWarpingWindow = -1;
        for (int i = 0; i < estimate; ++i) {
            SymbolicSequence testSeq = this.train[i];
            for (int w = 0; w <= this.maxWindow; ++w) {
                testSeq.LB_KeoghFillUL(w, this.U, this.L);
                double minD = Double.MAX_VALUE;
                String classValue = null;
                for (int j = 0; j < this.train.length; ++j) {
                    SymbolicSequence trainSeq;
                    if (i == j || !(SymbolicSequence.LB_KeoghPreFilled(trainSeq = this.train[j], this.U, this.L) < minD)) continue;
                    double tmpD = testSeq.DTW(trainSeq, w, this.warpingMatrix);
                    if (tmpD < minD) {
                        minD = tmpD;
                        classValue = this.classMap[j];
                        this.nns[w][i] = j;
                    }
                    this.dist[w][j] = tmpD * tmpD;
                }
                if (classValue == null || !classValue.equals(this.classMap[i])) {
                    int n = w;
                    nErrors[n] = nErrors[n] + 1;
                }
                score[w] = 1.0 * (double)nErrors[w] / (double)this.train.length;
            }
        }
        for (int w = 0; w < this.maxWindow; ++w) {
            if (!(score[w] < bestScore)) continue;
            bestScore = score[w];
            bestWarpingWindow = w;
        }
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    protected void searchBestWarpingWindow() {
        int currentWindow = this.forwardSearch ? 0 : this.maxWindow;
        bestScore = 1.0;
        this.searchResults = new String[this.maxWindow + 1];
        long startTime = System.currentTimeMillis();
        while (currentWindow >= 0 && currentWindow <= this.maxWindow) {
            double currentScore = this.evalSolution(currentWindow);
            long endTime = System.currentTimeMillis();
            long accumulatedTime = endTime - startTime;
            this.searchResults[currentWindow] = currentWindow + "," + currentScore + "," + accumulatedTime;
            if (currentScore < bestScore || currentScore == bestScore && !this.forwardSearch) {
                bestScore = currentScore;
                bestWarpingWindow = currentWindow;
            } else if (this.greedySearch && currentScore > bestScore) break;
            currentWindow = this.forwardSearch ? currentWindow + 1 : currentWindow - 1;
        }
    }

    protected double evalSolution(int warpingWindow) {
        int nErrors = 0;
        for (int i = 0; i < this.train.length; ++i) {
            SymbolicSequence testSeq = this.train[i];
            testSeq.LB_KeoghFillUL(warpingWindow, this.U, this.L);
            double minD = Double.MAX_VALUE;
            String classValue = null;
            for (int j = 0; j < this.train.length; ++j) {
                double tmpD;
                SymbolicSequence trainSeq;
                if (i == j || !(SymbolicSequence.LB_KeoghPreFilled(trainSeq = this.train[j], this.U, this.L) < minD) || !((tmpD = testSeq.DTW(trainSeq, warpingWindow, this.warpingMatrix)) < minD)) continue;
                minD = tmpD;
                classValue = this.classMap[j];
                this.nns[warpingWindow][i] = j;
                this.dist[warpingWindow][i] = minD;
            }
            if (classValue != null && classValue.equals(this.classMap[i])) continue;
            ++nErrors;
        }
        return 1.0 * (double)nErrors / (double)this.train.length;
    }

    @Override
    public double classifyInstance(Instance sample) throws Exception {
        Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
        int shift = sample.classIndex() == 0 ? 1 : 0;
        for (int t = 0; t < sequence.length; ++t) {
            sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
        }
        SymbolicSequence seq = new SymbolicSequence(sequence);
        double minD = Double.MAX_VALUE;
        String classValue = null;
        seq.LB_KeoghFillUL(bestWarpingWindow, this.U, this.L);
        for (int i = 0; i < this.train.length; ++i) {
            double tmpD;
            SymbolicSequence s = this.train[i];
            if (!(SymbolicSequence.LB_KeoghPreFilled(s, this.U, this.L) < minD) || !((tmpD = seq.DTW(s, bestWarpingWindow, this.warpingMatrix)) < minD)) continue;
            minD = tmpD;
            classValue = this.classMap[i];
        }
        return sample.classAttribute().indexOfValue(classValue);
    }

    int percentToLength(int windowInPercent) {
        return this.maxWindow * windowInPercent / 100;
    }

    int lengthToPercent(int windowInLength) {
        double r = 1.0 * (double)windowInLength / (double)this.maxWindow;
        return (int)Math.ceil(r * 100.0);
    }

    public String[] getSearchResults() {
        return this.searchResults;
    }

    public int getBestWin() {
        return bestWarpingWindow;
    }

    public int getBestPercent() {
        return bestWindowPercent;
    }

    public double getBestScore() {
        return bestScore;
    }

    public void setResDir(String path) {
        resDir = path;
    }

    public void setType(String t) {
        type = t;
    }

    public void setnParams(int n) {
        this.nParams = n;
    }

    static {
        bestWindowPercent = -1;
        type = "keogh";
        resDir = "/home/changwei/workspace/FindBestWarpingWindow/outputs/";
    }
}

