/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.windowSearcher;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import timeseriesweka.classifiers.FastWWS.items.Itemset;
import timeseriesweka.classifiers.FastWWS.items.LazyAssessNNEarlyAbandon;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.items.SequenceStatsCache;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class UCRSuite
extends WindowSearcher {
    private static final long serialVersionUID = -1561497612657542978L;
    public boolean forwardSearch = false;
    public boolean greedySearch = false;
    public PrintStream out = System.out;
    private String[] searchResults;
    private int[][] nns;
    private double[][] dist;
    private SequenceStatsCache cache;
    private LazyAssessNNEarlyAbandon[][] lazyUCR;

    public UCRSuite() {
    }

    public UCRSuite(String name) {
        datasetName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        int i;
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            ((ArrayList)this.classedData.get(clas)).add(this.train[i]);
            ((ArrayList)this.classedDataIndices.get(clas)).add(i);
        }
        this.warpingMatrix = new double[this.maxLength][this.maxLength];
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.U1 = new double[this.maxLength];
        this.L1 = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.searchResults = new String[this.maxWindow + 1];
        this.nns = new int[this.maxWindow + 1][this.train.length];
        this.dist = new double[this.maxWindow + 1][this.train.length];
        this.cache = new SequenceStatsCache(this.train, this.maxWindow);
        this.lazyUCR = new LazyAssessNNEarlyAbandon[this.train.length][this.train.length];
        for (i = 0; i < this.train.length; ++i) {
            for (int j = 0; j < this.train.length; ++j) {
                this.lazyUCR[i][j] = new LazyAssessNNEarlyAbandon(this.cache);
            }
        }
        this.searchBestWarpingWindow();
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    @Override
    protected void searchBestWarpingWindow() {
        int currentWindow = this.forwardSearch ? 0 : this.maxWindow;
        double currentScore = 1.0;
        bestScore = 1.0;
        long startTime = System.currentTimeMillis();
        while (currentWindow >= 0 && currentWindow <= this.maxWindow) {
            currentScore = this.evalSolution(currentWindow);
            long endTime = System.currentTimeMillis();
            long accumulatedTime = endTime - startTime;
            this.searchResults[currentWindow] = currentWindow + "," + currentScore + "," + accumulatedTime;
            if (currentScore < bestScore || currentScore == bestScore && !this.forwardSearch) {
                bestScore = currentScore;
                bestWarpingWindow = currentWindow;
            } else if (this.greedySearch && currentScore > bestScore) break;
            currentWindow = this.forwardSearch ? currentWindow + 1 : currentWindow - 1;
        }
    }

    @Override
    protected double evalSolution(int warpingWindow) {
        int nErrors = 0;
        for (int i = 0; i < this.train.length; ++i) {
            double minD = Double.MAX_VALUE;
            String classValue = null;
            for (int j = 0; j < this.train.length; ++j) {
                if (i == j) continue;
                this.lazyUCR[i][j].set(this.train[i], i, this.train[j], j);
                LazyAssessNNEarlyAbandon.RefineReturnType rrt = this.lazyUCR[i][j].tryToBeat(minD, warpingWindow);
                if (rrt != LazyAssessNNEarlyAbandon.RefineReturnType.New_best) continue;
                minD = this.lazyUCR[i][j].getDistance(warpingWindow);
                this.nns[warpingWindow][i] = j;
                this.dist[warpingWindow][i] = minD;
                classValue = this.classMap[j];
            }
            if (classValue != null && classValue.equals(this.classMap[i])) continue;
            ++nErrors;
        }
        return 1.0 * (double)nErrors / (double)this.train.length;
    }

    @Override
    public double classifyInstance(Instance sample) throws Exception {
        Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
        int shift = sample.classIndex() == 0 ? 1 : 0;
        for (int t = 0; t < sequence.length; ++t) {
            sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
        }
        SymbolicSequence seq = new SymbolicSequence(sequence);
        double minD = Double.MAX_VALUE;
        String classValue = null;
        seq.LB_KeoghFillUL(bestWarpingWindow, this.U, this.L);
        for (int i = 0; i < this.train.length; ++i) {
            double tmpD;
            SymbolicSequence s = this.train[i];
            if (!(SymbolicSequence.LB_KeoghPreFilled(s, this.U, this.L) < minD) || !((tmpD = seq.DTW(s, bestWarpingWindow, this.warpingMatrix)) < minD)) continue;
            minD = tmpD;
            classValue = this.classMap[i];
        }
        return sample.classAttribute().indexOfValue(classValue);
    }

    @Override
    public String[] getSearchResults() {
        return this.searchResults;
    }

    @Override
    public int getBestWin() {
        return bestWarpingWindow;
    }

    @Override
    public double getBestScore() {
        return bestScore;
    }

    @Override
    public void setResDir(String path) {
        resDir = path;
    }

    @Override
    public void setType(String t) {
        type = t;
    }
}

