/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.windowSearcher;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import timeseriesweka.classifiers.FastWWS.items.Itemset;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.items.SequenceStatsCache;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class Trillion
extends WindowSearcher {
    private static final long serialVersionUID = 1L;
    public PrintStream out = System.out;
    private SequenceStatsCache cache;
    private SymbolicSequence query;
    private SymbolicSequence reference;
    private int indexQuery;
    private int indexReference;
    private double minDist;
    private double bestMinDist;
    private int currentW;
    private int indexStoppedLB;

    public Trillion() {
    }

    public Trillion(String name) {
        datasetName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            ((ArrayList)this.classedData.get(clas)).add(this.train[i]);
            ((ArrayList)this.classedDataIndices.get(clas)).add(i);
        }
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.cache = new SequenceStatsCache(this.train, this.maxWindow);
        int nbErrors = 0;
        bestScore = Double.MAX_VALUE;
        bestWarpingWindow = -1;
        for (int w = 0; w <= this.maxWindow; ++w) {
            this.currentW = w;
            nbErrors = 0;
            for (int i = 0; i < this.train.length; ++i) {
                this.query = this.train[i];
                this.indexQuery = i;
                this.bestMinDist = Double.MAX_VALUE;
                String classValue = null;
                for (int j = 0; j < this.train.length; ++j) {
                    if (i == j) continue;
                    this.reference = this.train[j];
                    this.indexReference = j;
                    this.doLBKim();
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.minDist = 0.0;
                    this.indexStoppedLB = 0;
                    this.doLBKeoghQR(this.bestMinDist);
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.minDist = 0.0;
                    this.indexStoppedLB = 0;
                    this.doLBKeoghRQ(this.bestMinDist);
                    if (!(this.minDist < this.bestMinDist)) continue;
                    double res = this.query.DTW(this.reference, this.currentW);
                    this.minDist = res * res;
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.bestMinDist = this.minDist;
                    classValue = this.classMap[j];
                }
                if (classValue != null && classValue.equals(this.classMap[i])) continue;
                ++nbErrors;
            }
            double score = 1.0 * (double)nbErrors / (double)this.train.length;
            if (!(score < bestScore)) continue;
            bestScore = score;
            bestWarpingWindow = w;
        }
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    @Override
    public void buildClassifierEstimate(Instances data, int estimate) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            ((ArrayList)this.classedData.get(clas)).add(this.train[i]);
            ((ArrayList)this.classedDataIndices.get(clas)).add(i);
        }
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.cache = new SequenceStatsCache(this.train, this.maxWindow);
        int[] nbErrors = new int[this.maxWindow + 1];
        double[] score = new double[this.maxWindow + 1];
        bestScore = Double.MAX_VALUE;
        bestWarpingWindow = -1;
        for (int i = 0; i < estimate; ++i) {
            this.query = this.train[i];
            this.indexQuery = i;
            for (int w = 0; w <= this.maxWindow; ++w) {
                this.currentW = w;
                this.bestMinDist = Double.MAX_VALUE;
                String classValue = null;
                for (int j = 0; j < this.train.length; ++j) {
                    if (i == j) continue;
                    this.reference = this.train[j];
                    this.indexReference = j;
                    this.doLBKim();
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.minDist = 0.0;
                    this.indexStoppedLB = 0;
                    this.doLBKeoghQR(this.bestMinDist);
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.minDist = 0.0;
                    this.indexStoppedLB = 0;
                    this.doLBKeoghRQ(this.bestMinDist);
                    if (!(this.minDist < this.bestMinDist)) continue;
                    double res = this.query.DTW(this.reference, this.currentW);
                    this.minDist = res * res;
                    if (!(this.minDist < this.bestMinDist)) continue;
                    this.bestMinDist = this.minDist;
                    classValue = this.classMap[j];
                }
                if (classValue == null || !classValue.equals(this.classMap[i])) {
                    int n = w;
                    nbErrors[n] = nbErrors[n] + 1;
                }
                score[w] = 1.0 * (double)nbErrors[w] / (double)this.train.length;
            }
        }
        for (int w = 0; w < this.maxWindow; ++w) {
            if (!(score[w] < bestScore)) continue;
            bestScore = score[w];
            bestWarpingWindow = w;
        }
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    @Override
    public double classifyInstance(Instance sample) throws Exception {
        Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
        int shift = sample.classIndex() == 0 ? 1 : 0;
        for (int t = 0; t < sequence.length; ++t) {
            sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
        }
        SymbolicSequence seq = new SymbolicSequence(sequence);
        double minD = Double.MAX_VALUE;
        String classValue = null;
        seq.LB_KeoghFillUL(bestWarpingWindow, this.U, this.L);
        for (int i = 0; i < this.train.length; ++i) {
            double tmpD;
            SymbolicSequence s = this.train[i];
            if (!(SymbolicSequence.LB_KeoghPreFilled(s, this.U, this.L) < minD) || !((tmpD = seq.DTW(s, bestWarpingWindow)) < minD)) continue;
            minD = tmpD;
            classValue = this.classMap[i];
        }
        return sample.classAttribute().indexOfValue(classValue);
    }

    public void doLBKim() {
        double diffFirsts = this.query.sequence[0].squaredDistance(this.reference.sequence[0]);
        double diffLasts = this.query.sequence[this.query.getNbTuples() - 1].squaredDistance(this.reference.sequence[this.reference.getNbTuples() - 1]);
        this.minDist = diffFirsts + diffLasts;
        if (!(this.cache.isMinFirst(this.indexQuery) || this.cache.isMinFirst(this.indexReference) || this.cache.isMinLast(this.indexQuery) || this.cache.isMinLast(this.indexReference))) {
            double diffMin = this.cache.getMin(this.indexQuery) - this.cache.getMin(this.indexReference);
            this.minDist += diffMin * diffMin;
        }
        if (!(this.cache.isMaxFirst(this.indexQuery) || this.cache.isMaxFirst(this.indexReference) || this.cache.isMaxLast(this.indexQuery) || this.cache.isMaxLast(this.indexReference))) {
            double diffMax = this.cache.getMax(this.indexQuery) - this.cache.getMax(this.indexReference);
            this.minDist += diffMax * diffMax;
        }
    }

    public void doLBKeoghQR(double scoreToBeat) {
        int length = this.query.sequence.length;
        double[] LEQ = this.cache.getLE(this.indexQuery, this.currentW);
        double[] UEQ = this.cache.getUE(this.indexQuery, this.currentW);
        while (this.indexStoppedLB < length && this.minDist < scoreToBeat) {
            double diff;
            int index;
            double c = ((MonoDoubleItemSet)this.reference.sequence[index]).value;
            index = this.cache.getIndexNthHighestVal(this.indexReference, this.indexStoppedLB);
            if (c < LEQ[index]) {
                diff = LEQ[index] - c;
                this.minDist += diff * diff;
            } else if (UEQ[index] < c) {
                diff = UEQ[index] - c;
                this.minDist += diff * diff;
            }
            ++this.indexStoppedLB;
        }
    }

    public void doLBKeoghRQ(double scoreToBeat) {
        int length = this.reference.sequence.length;
        double[] LER = this.cache.getLE(this.indexReference, this.currentW);
        double[] UER = this.cache.getUE(this.indexReference, this.currentW);
        while (this.indexStoppedLB < length && this.minDist < scoreToBeat) {
            double diff;
            int index;
            double c = ((MonoDoubleItemSet)this.query.sequence[index]).value;
            index = this.cache.getIndexNthHighestVal(this.indexQuery, this.indexStoppedLB);
            if (c < LER[index]) {
                diff = LER[index] - c;
                this.minDist += diff * diff;
            } else if (UER[index] < c) {
                diff = UER[index] - c;
                this.minDist += diff * diff;
            }
            ++this.indexStoppedLB;
        }
    }

    @Override
    public int getBestWin() {
        return bestWarpingWindow;
    }

    @Override
    public double getBestScore() {
        return bestScore;
    }

    @Override
    public void setResDir(String path) {
        resDir = path;
    }

    @Override
    public void setType(String t) {
        type = t;
    }
}

