/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.windowSearcher;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import timeseriesweka.classifiers.FastWWS.items.Itemset;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public class LbKeoghPrunedDTW
extends WindowSearcher {
    private static final long serialVersionUID = -1561497612657542978L;
    public PrintStream out = System.out;
    private String[] searchResults;
    private int[][] nns;
    private double[][] dist;

    public LbKeoghPrunedDTW() {
    }

    public LbKeoghPrunedDTW(String name) {
        datasetName = name;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            ((ArrayList)this.classedData.get(clas)).add(this.train[i]);
            ((ArrayList)this.classedDataIndices.get(clas)).add(i);
        }
        this.warpingMatrix = new double[this.maxLength][this.maxLength];
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.searchResults = new String[this.maxWindow + 1];
        this.nns = new int[this.maxWindow + 1][this.train.length];
        this.dist = new double[this.train.length][this.train.length];
        this.searchBestWarpingWindow();
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    @Override
    public void buildClassifierEstimate(Instances data, int estimate) throws Exception {
        Attribute classAttribute = data.classAttribute();
        this.classedData = new HashMap();
        this.classedDataIndices = new HashMap();
        for (int c = 0; c < data.numClasses(); ++c) {
            this.classedData.put(data.classAttribute().value(c), new ArrayList());
            this.classedDataIndices.put(data.classAttribute().value(c), new ArrayList());
        }
        this.train = new SymbolicSequence[data.numInstances()];
        this.classMap = new String[this.train.length];
        this.maxLength = 0;
        for (int i = 0; i < this.train.length; ++i) {
            String clas;
            Instance sample = data.instance(i);
            Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
            this.maxLength = Math.max(this.maxLength, sequence.length);
            int shift = sample.classIndex() == 0 ? 1 : 0;
            for (int t = 0; t < sequence.length; ++t) {
                sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
            }
            this.train[i] = new SymbolicSequence(sequence);
            this.classMap[i] = clas = sample.stringValue(classAttribute);
            ((ArrayList)this.classedData.get(clas)).add(this.train[i]);
            ((ArrayList)this.classedDataIndices.get(clas)).add(i);
        }
        this.warpingMatrix = new double[this.maxLength][this.maxLength];
        this.U = new double[this.maxLength];
        this.L = new double[this.maxLength];
        this.maxWindow = Math.round(1 * this.maxLength);
        this.searchResults = new String[this.maxWindow + 1];
        this.nns = new int[this.maxWindow + 1][this.train.length];
        this.dist = new double[this.train.length][this.train.length];
        int[] nErrors = new int[this.maxWindow + 1];
        double[] score = new double[this.maxWindow + 1];
        double bestScore = Double.MAX_VALUE;
        bestWarpingWindow = -1;
        for (int i = 0; i < estimate; ++i) {
            SymbolicSequence testSeq = this.train[i];
            for (int w = 0; w <= this.maxWindow; ++w) {
                testSeq.LB_KeoghFillUL(w, this.U, this.L);
                double minD = Double.MAX_VALUE;
                String classValue = null;
                for (int j = 0; j < this.train.length; ++j) {
                    if (i == j) continue;
                    SymbolicSequence trainSeq = this.train[j];
                    if (SymbolicSequence.LB_KeoghPreFilled(trainSeq, this.U, this.L) < minD) {
                        double tmpD = w == 0 ? testSeq.PrunedDTW(trainSeq, w) : testSeq.PrunedDTW(trainSeq, w, this.dist[i][j]);
                        if (tmpD < minD) {
                            minD = tmpD;
                            classValue = this.classMap[j];
                            this.nns[w][i] = j;
                        }
                        this.dist[i][j] = tmpD * tmpD;
                        continue;
                    }
                    this.dist[i][j] = w > 0 ? this.dist[i][j] : Double.MAX_VALUE;
                }
                if (classValue == null || !classValue.equals(this.classMap[i])) {
                    int n = w;
                    nErrors[n] = nErrors[n] + 1;
                }
                score[w] = 1.0 * (double)nErrors[w] / (double)this.train.length;
            }
        }
        for (int w = 0; w < this.maxWindow; ++w) {
            if (!(score[w] < bestScore)) continue;
            bestScore = score[w];
            bestWarpingWindow = w;
        }
        System.out.println("Windows found=" + bestWarpingWindow + " Best Acc=" + (1.0 - bestScore));
    }

    @Override
    protected void searchBestWarpingWindow() {
        double currentScore = 1.0;
        bestScore = 1.0;
        long startTime = System.currentTimeMillis();
        for (int currentWindow = 0; currentWindow >= 0 && currentWindow <= this.maxWindow; ++currentWindow) {
            currentScore = this.evalSolution(currentWindow);
            long endTime = System.currentTimeMillis();
            long accumulatedTime = endTime - startTime;
            this.searchResults[currentWindow] = currentWindow + "," + currentScore + "," + accumulatedTime;
            if (!(currentScore < bestScore)) continue;
            bestScore = currentScore;
            bestWarpingWindow = currentWindow;
        }
    }

    @Override
    protected double evalSolution(int warpingWindow) {
        int nErrors = 0;
        for (int i = 0; i < this.train.length; ++i) {
            SymbolicSequence testSeq = this.train[i];
            testSeq.LB_KeoghFillUL(warpingWindow, this.U, this.L);
            double minD = Double.MAX_VALUE;
            String classValue = null;
            for (int j = 0; j < this.train.length; ++j) {
                if (i == j) continue;
                SymbolicSequence trainSeq = this.train[j];
                if (SymbolicSequence.LB_KeoghPreFilled(trainSeq, this.U, this.L) < minD) {
                    double tmpD = warpingWindow == 0 ? testSeq.PrunedDTW(trainSeq, warpingWindow) : testSeq.PrunedDTW(trainSeq, warpingWindow, this.dist[i][j]);
                    if (tmpD < minD) {
                        minD = tmpD;
                        classValue = this.classMap[j];
                        this.nns[warpingWindow][i] = j;
                    }
                    this.dist[i][j] = tmpD * tmpD;
                    continue;
                }
                this.dist[i][j] = warpingWindow > 0 ? this.dist[i][j] : Double.MAX_VALUE;
            }
            if (classValue != null && classValue.equals(this.classMap[i])) continue;
            ++nErrors;
        }
        return 1.0 * (double)nErrors / (double)this.train.length;
    }

    @Override
    public double classifyInstance(Instance sample) throws Exception {
        Itemset[] sequence = new MonoDoubleItemSet[sample.numAttributes() - 1];
        int shift = sample.classIndex() == 0 ? 1 : 0;
        for (int t = 0; t < sequence.length; ++t) {
            sequence[t] = new MonoDoubleItemSet(sample.value(t + shift));
        }
        SymbolicSequence seq = new SymbolicSequence(sequence);
        double minD = Double.MAX_VALUE;
        String classValue = null;
        seq.LB_KeoghFillUL(bestWarpingWindow, this.U, this.L);
        for (int i = 0; i < this.train.length; ++i) {
            double tmpD;
            SymbolicSequence s = this.train[i];
            if (!(SymbolicSequence.LB_KeoghPreFilled(s, this.U, this.L) < minD) || !((tmpD = seq.DTW(s, bestWarpingWindow, this.warpingMatrix)) < minD)) continue;
            minD = tmpD;
            classValue = this.classMap[i];
        }
        return sample.classAttribute().indexOfValue(classValue);
    }

    @Override
    public String[] getSearchResults() {
        return this.searchResults;
    }

    @Override
    public int getBestWin() {
        return bestWarpingWindow;
    }

    @Override
    public double getBestScore() {
        return bestScore;
    }

    @Override
    public void setResDir(String path) {
        resDir = path;
    }

    @Override
    public void setType(String t) {
        type = t;
    }
}

