/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.windowSearcher;

import java.util.ArrayList;
import java.util.Collections;
import timeseriesweka.classifiers.FastWWS.items.LazyAssessNN;
import timeseriesweka.classifiers.FastWWS.items.SequenceStatsCache;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;

public class FastWWS
extends WindowSearcher {
    private static final long serialVersionUID = 1536192551485201554L;
    private PotentialNN[][] nns;
    private boolean init;

    public FastWWS() {
        this.forwardSearch = false;
        this.init = false;
    }

    public FastWWS(String name) {
        this.forwardSearch = false;
        this.init = false;
        datasetName = name;
    }

    public String doTime(long start) {
        long duration = System.currentTimeMillis() - start;
        return "" + duration / 1000L + " s " + duration % 1000L + " ms";
    }

    public String doTime(long start, long now) {
        long duration = now - start;
        return "" + duration / 1000L + " s " + duration % 1000L + " ms";
    }

    protected void initTable() {
        if (this.train.length < 2) {
            System.err.println("Set is to small: " + this.train.length + " sequence. At least 2 sequences needed.");
        }
        System.out.println("Starting optimisation");
        long timeInit = System.currentTimeMillis();
        SequenceStatsCache cache = new SequenceStatsCache(this.train, this.maxWindow);
        this.nns = new PotentialNN[this.maxWindow + 1][this.train.length];
        for (int win = 0; win < this.maxWindow + 1; ++win) {
            for (int len = 0; len < this.train.length; ++len) {
                this.nns[win][len] = new PotentialNN();
            }
        }
        LazyAssessNN[] lazyUCR = new LazyAssessNN[this.train.length];
        for (int i = 0; i < this.train.length; ++i) {
            lazyUCR[i] = new LazyAssessNN(cache);
        }
        ArrayList<LazyAssessNN> challengers = new ArrayList<LazyAssessNN>(this.train.length);
        System.out.println("Initialisation done (" + this.doTime(timeInit) + ")");
        for (int current = 1; current < this.train.length; ++current) {
            SymbolicSequence sCurrent = this.train[current];
            challengers.clear();
            for (int previous = 0; previous < current; ++previous) {
                LazyAssessNN d = lazyUCR[previous];
                d.set(this.train[previous], previous, sCurrent, current);
                challengers.add(d);
            }
            for (int win = this.maxWindow; win > -1; --win) {
                PotentialNN currPNN = this.nns[win][current];
                if (currPNN.isNN()) {
                    for (int previous = 0; previous < current; ++previous) {
                        PotentialNN prevNN = this.nns[win][previous];
                        LazyAssessNN challenger = lazyUCR[previous];
                        double toBeat = prevNN.distance;
                        LazyAssessNN.RefineReturnType rrt = challenger.tryToBeat(toBeat, win);
                        if (rrt != LazyAssessNN.RefineReturnType.New_best) continue;
                        int r = challenger.getMinWindowValidityForFullDistance();
                        double d = challenger.getDistance(win);
                        prevNN.set(current, r, d, PotentialNN.Status.NN);
                    }
                    continue;
                }
                Collections.sort(challengers);
                for (LazyAssessNN challenger : challengers) {
                    double d;
                    int r;
                    int previous = challenger.indexQuery;
                    PotentialNN prevNN = this.nns[win][previous];
                    double toBeat = currPNN.distance;
                    LazyAssessNN.RefineReturnType rrt = challenger.tryToBeat(toBeat, win);
                    if (rrt == LazyAssessNN.RefineReturnType.New_best) {
                        r = challenger.getMinWindowValidityForFullDistance();
                        d = challenger.getDistance(win);
                        currPNN.set(previous, r, d, PotentialNN.Status.BC);
                    }
                    if ((rrt = (challenger = lazyUCR[previous]).tryToBeat(toBeat = prevNN.distance, win)) != LazyAssessNN.RefineReturnType.New_best) continue;
                    r = challenger.getMinWindowValidityForFullDistance();
                    d = challenger.getDistance(win);
                    prevNN.set(current, r, d, PotentialNN.Status.NN);
                }
                int r = currPNN.r;
                double d = currPNN.distance;
                int index = currPNN.index;
                for (int w = win; w >= r; --w) {
                    this.nns[w][current].set(index, r, d, PotentialNN.Status.NN);
                }
            }
        }
        System.out.println("done! (" + this.doTime(timeInit) + ")");
        this.init = true;
    }

    @Override
    protected double evalSolution(int warpingWindow) {
        if (!this.init) {
            this.initTable();
        }
        int nErrors = 0;
        for (int i = 0; i < this.train.length; ++i) {
            if (this.classMap[this.nns[warpingWindow][i].index].equals(this.classMap[i])) continue;
            ++nErrors;
        }
        return 1.0 * (double)nErrors / (double)this.train.length;
    }

    @Override
    public int getBestWin() {
        return bestWarpingWindow;
    }

    @Override
    public double getBestScore() {
        return bestScore;
    }

    @Override
    public void setResDir(String path) {
        resDir = path;
    }

    @Override
    public void setType(String t) {
        type = t;
    }

    private static class PotentialNN {
        public int index = Integer.MIN_VALUE;
        public int r = Integer.MAX_VALUE;
        public double distance = Double.POSITIVE_INFINITY;
        public Status status = Status.BC;

        public void set(int index, int r, double distance, Status status) {
            this.index = index;
            this.r = r;
            this.distance = distance;
            this.status = status;
        }

        public boolean isNN() {
            return this.status == Status.NN;
        }

        public String toString() {
            return "" + this.index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PotentialNN that = (PotentialNN)o;
            return this.index == that.index;
        }

        public static enum Status {
            NN,
            BC;

        }
    }
}

