/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.tools;

import java.util.Random;
import timeseriesweka.classifiers.FastWWS.tools.QuickSort;
import weka.core.Instances;

public class Sampling {
    public static Instances[] sample(Instances train, int numTrain, Instances test, int numTest) {
        Instances trainDataset = new Instances(train, numTrain);
        trainDataset = Sampling.random(train);
        trainDataset = new Instances(trainDataset, 0, numTrain);
        Instances testDataset = new Instances(test, numTest);
        testDataset = Sampling.random(test);
        testDataset = new Instances(testDataset, 0, numTest);
        return new Instances[]{trainDataset, testDataset};
    }

    public static Instances sample(Instances data, int size) {
        Instances newData = new Instances(data, size);
        newData = Sampling.random(data);
        newData = new Instances(newData, 0, size);
        return newData;
    }

    public static Instances random(Instances data) {
        data.randomize(new Random());
        return data;
    }

    public static Instances orderByLargestClass(Instances data) {
        int i;
        Instances newData = new Instances(data, data.numInstances());
        int nbClass = data.numClasses();
        int[] instancePerClass = new int[nbClass];
        int[] labels = new int[nbClass];
        int[] classIndex = new int[nbClass];
        data.sort(data.classAttribute());
        for (i = 0; i < nbClass; ++i) {
            instancePerClass[i] = data.attributeStats((int)data.classIndex()).nominalCounts[i];
            labels[i] = i;
            if (i <= 0) continue;
            classIndex[i] = classIndex[i - 1] + instancePerClass[i - 1];
        }
        QuickSort.sort(instancePerClass, labels);
        for (i = nbClass - 1; i >= 0; --i) {
            for (int j = 0; j < instancePerClass[i]; ++j) {
                newData.add(data.instance(classIndex[labels[i]] + j));
            }
        }
        return newData;
    }

    public static Instances orderByCompactClass(Instances data) {
        int i;
        Instances newData = new Instances(data, data.numInstances());
        int nbClass = data.numClasses();
        int[] instancePerClass = new int[nbClass];
        int[] labels = new int[nbClass];
        int[] classIndex = new int[nbClass];
        double[] compactness = new double[nbClass];
        data.sort(data.classAttribute());
        int start = 0;
        for (i = 0; i < nbClass; ++i) {
            instancePerClass[i] = data.attributeStats((int)data.classIndex()).nominalCounts[i];
            labels[i] = i;
            if (i > 0) {
                classIndex[i] = classIndex[i - 1] + instancePerClass[i - 1];
            }
            int end = start + instancePerClass[i];
            int counter = 0;
            double[][] dataPerClass = new double[instancePerClass[i]][data.numAttributes() - 1];
            for (int j = start; j < end; ++j) {
                dataPerClass[counter++] = data.instance(j).toDoubleArray();
            }
            double[] mean = Sampling.arithmeticMean(dataPerClass);
            double d = 0.0;
            for (int j = 0; j < instancePerClass[i]; ++j) {
                double temp = Sampling.euclideanDistance(mean, dataPerClass[j]);
                temp *= temp;
                d += (temp -= (mean[0] - dataPerClass[j][0]) * (mean[0] - dataPerClass[j][0]));
            }
            compactness[i] = d / (double)instancePerClass[i];
            start = end;
        }
        QuickSort.sort(compactness, labels);
        for (i = nbClass - 1; i >= 0; --i) {
            for (int j = 0; j < instancePerClass[labels[i]]; ++j) {
                newData.add(data.instance(classIndex[labels[i]] + j));
            }
        }
        return newData;
    }

    private static double euclideanDistance(double[] x, double[] y) {
        double dist = 0.0;
        for (int i = 0; i < x.length; ++i) {
            dist += (x[i] - y[i]) * (x[i] - y[i]);
        }
        return Math.sqrt(dist);
    }

    public static double[] arithmeticMean(double[][] array) {
        double[] mean = new double[array[0].length];
        int i = 0;
        while (i < array[0].length) {
            for (int j = 0; j < array.length; ++j) {
                int n = i;
                mean[n] = mean[n] + array[j][i];
            }
            int n = i++;
            mean[n] = mean[n] / (double)array.length;
        }
        return mean;
    }
}

