/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.sequences;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import timeseriesweka.classifiers.FastWWS.items.DTWResult;
import timeseriesweka.classifiers.FastWWS.items.Itemset;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.items.MonoItemSet;
import timeseriesweka.classifiers.FastWWS.tools.Tools;

public class SymbolicSequence
implements Serializable {
    private static final long serialVersionUID = -8340081464719919763L;
    public static int w = Integer.MAX_VALUE;
    protected static final int NB_ITERATIONS = 15;
    protected static final int RIEN = -1;
    protected static final int DIAGONALE = 0;
    protected static final int GAUCHE = 1;
    protected static final int HAUT = 2;
    public Itemset[] sequence;
    public static long nDTWExt;
    private static final int MAX_SEQ_LENGTH = 8000;
    public static double[][] matriceW;
    public static int[][] matriceChoix;
    protected static int[][] optimalPathLength;
    protected static int[][] minWarpingWindow;
    public static double[] ub_partials;

    public SymbolicSequence(Itemset[] sequence) {
        if (sequence == null || sequence.length == 0) {
            throw new RuntimeException("sequence vide");
        }
        this.sequence = sequence;
    }

    public SymbolicSequence(SymbolicSequence o) {
        if (o.sequence == null || o.sequence.length == 0) {
            throw new RuntimeException("sequence vide");
        }
        this.sequence = o.sequence;
    }

    public Object clone() {
        Itemset[] newSequence = Arrays.copyOf(this.sequence, this.sequence.length);
        for (int i = 0; i < newSequence.length; ++i) {
            newSequence[i] = this.sequence[i].clone();
        }
        return new SymbolicSequence(newSequence);
    }

    public Itemset getItem(int n) {
        return this.sequence[n];
    }

    public final int getNbTuples() {
        return this.sequence.length;
    }

    public final double distanceEuc(SymbolicSequence a) {
        int length = this.getNbTuples();
        double res = 0.0;
        for (int i = 0; i < length; ++i) {
            res += this.sequence[i].squaredDistance(a.sequence[i]);
        }
        return Math.sqrt(res);
    }

    public final double squaredEucEarlyAbandon(SymbolicSequence a, double max) {
        Itemset[] series1 = this.sequence;
        Itemset[] series2 = a.sequence;
        int minLength = Math.min(series1.length, series2.length);
        double distance = 0.0;
        for (int i = 0; i < minLength; ++i) {
            if (!((distance += series1[i].squaredDistance(series2[i])) >= max)) continue;
            return Double.MAX_VALUE;
        }
        return distance;
    }

    public final double distanceEucNormalized(SymbolicSequence a) {
        Itemset[] series1 = this.sequence;
        Itemset[] series2 = a.sequence;
        int minLength = Math.min(series1.length, series2.length);
        double distance = 0.0;
        for (int i = 0; i < minLength; ++i) {
            distance += series1[i].squaredDistance(series2[i]);
        }
        return Math.sqrt(distance) / (double)minLength;
    }

    public final double squaredEucEarlyAbandonNormalized(SymbolicSequence a, double max) {
        Itemset[] series1 = this.sequence;
        Itemset[] series2 = a.sequence;
        int minLength = Math.min(series1.length, series2.length);
        double distance = 0.0;
        for (int i = 0; i < minLength; ++i) {
            if (!((distance += series1[i].squaredDistance(series2[i])) / (double)(i + 1) >= max)) continue;
            return Double.MAX_VALUE;
        }
        return distance / (double)minLength;
    }

    public final double LB_Keogh(SymbolicSequence a, int r) {
        int length = Math.min(this.getNbTuples(), a.getNbTuples());
        double[] U = new double[length];
        double[] L = new double[length];
        for (int i = 0; i < length; ++i) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int startR = Math.max(0, i - r);
            int stopR = Math.min(length - 1, i + r);
            for (int j = startR; j <= stopR; ++j) {
                double value = ((MonoDoubleItemSet)this.sequence[j]).value;
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            L[i] = min;
            U[i] = max;
        }
        double res = 0.0;
        for (int i = 0; i < length; ++i) {
            double diff;
            double c = ((MonoDoubleItemSet)a.sequence[i]).value;
            if (c < L[i]) {
                diff = L[i] - c;
                res += diff * diff;
                continue;
            }
            if (!(U[i] < c)) continue;
            diff = U[i] - c;
            res += diff * diff;
        }
        return Math.sqrt(res);
    }

    public final double LB_Keogh(SymbolicSequence a, int r, double[] U, double[] L) {
        this.LB_KeoghFillUL(r, U, L);
        return SymbolicSequence.LB_KeoghPreFilled(a, U, L);
    }

    public final void LB_KeoghFillUL(int r, double[] U, double[] L) {
        int length = this.getNbTuples();
        for (int i = 0; i < length; ++i) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int startR = Math.max(0, i - r);
            int stopR = Math.min(length - 1, i + r);
            for (int j = startR; j <= stopR; ++j) {
                double value = ((MonoDoubleItemSet)this.sequence[j]).value;
                min = Math.min(min, value);
                max = Math.max(max, value);
            }
            L[i] = min;
            U[i] = max;
        }
    }

    public static final double LB_KeoghPreFilled(SymbolicSequence a, double[] U, double[] L) {
        int length = Math.min(U.length, a.getNbTuples());
        double res = 0.0;
        for (int i = 0; i < length; ++i) {
            double diff;
            double c = ((MonoDoubleItemSet)a.sequence[i]).value;
            if (c < L[i]) {
                diff = L[i] - c;
                res += diff * diff;
                continue;
            }
            if (!(U[i] < c)) continue;
            diff = U[i] - c;
            res += diff * diff;
        }
        return Math.sqrt(res);
    }

    public synchronized double distance(SymbolicSequence a) {
        return this.distance(a, matriceW);
    }

    public double distance(SymbolicSequence a, double[][] matriceW) {
        int j;
        int i;
        SymbolicSequence S1 = this;
        SymbolicSequence S2 = a;
        int tailleS = S1.getNbTuples();
        int tailleT = S2.getNbTuples();
        matriceW[0][0] = S1.sequence[0].squaredDistance(S2.sequence[0]);
        for (i = 1; i < tailleS; ++i) {
            matriceW[i][0] = matriceW[i - 1][0] + S1.sequence[i].squaredDistance(S2.sequence[0]);
        }
        for (j = 1; j < tailleT; ++j) {
            matriceW[0][j] = matriceW[0][j - 1] + S1.sequence[0].squaredDistance(S2.sequence[j]);
        }
        for (i = 1; i < tailleS; ++i) {
            for (j = 1; j < tailleT; ++j) {
                matriceW[i][j] = Tools.Min3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]) + S1.sequence[i].squaredDistance(S2.sequence[j]);
            }
        }
        return Math.sqrt(matriceW[tailleS - 1][tailleT - 1]);
    }

    public double ED(SymbolicSequence a) {
        double sum = 0.0;
        for (int i = 0; i < this.getNbTuples(); ++i) {
            sum += this.sequence[i].squaredDistance(a.sequence[i]);
        }
        return Math.sqrt(sum);
    }

    public synchronized double DTW(SymbolicSequence a, int w) {
        return this.DTW(a, w, matriceW);
    }

    public double DTW(SymbolicSequence a, int w, double[][] warpingMatrix) {
        int j;
        int i;
        int length1 = this.getNbTuples();
        int length2 = a.getNbTuples();
        warpingMatrix[0][0] = this.sequence[0].squaredDistance(a.sequence[0]);
        for (i = 1; i < Math.min(length1, 1 + w); ++i) {
            warpingMatrix[i][0] = warpingMatrix[i - 1][0] + this.sequence[i].squaredDistance(a.sequence[0]);
        }
        for (j = 1; j < Math.min(length2, 1 + w); ++j) {
            warpingMatrix[0][j] = warpingMatrix[0][j - 1] + this.sequence[0].squaredDistance(a.sequence[j]);
        }
        if (j < length2) {
            warpingMatrix[0][j] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i < length1; ++i) {
            int jStart = Math.max(1, i - w);
            int jStop = Math.min(length2, i + w + 1);
            int indexInftyLeft = i - w - 1;
            if (indexInftyLeft >= 0) {
                warpingMatrix[i][indexInftyLeft] = Double.POSITIVE_INFINITY;
            }
            for (j = jStart; j < jStop; ++j) {
                warpingMatrix[i][j] = Tools.Min3(warpingMatrix[i - 1][j - 1], warpingMatrix[i][j - 1], warpingMatrix[i - 1][j]) + this.sequence[i].squaredDistance(a.sequence[j]);
            }
            if (jStop >= length2) continue;
            warpingMatrix[i][jStop] = Double.POSITIVE_INFINITY;
        }
        return Math.sqrt(warpingMatrix[length1 - 1][length2 - 1]);
    }

    public double PrunedDTW(SymbolicSequence T, int w) {
        int i;
        ++nDTWExt;
        int tailleS = this.getNbTuples();
        int tailleT = T.getNbTuples();
        double res = 0.0;
        int sc = 1;
        int ec = 1;
        int ec_next = 0;
        double UB = 0.0;
        SymbolicSequence.ub_partials[tailleS] = 0.0;
        for (i = tailleS - 1; i >= 0; --i) {
            SymbolicSequence.ub_partials[i] = ub_partials[i + 1] + this.sequence[i].squaredDistance(T.sequence[i]);
            SymbolicSequence.matriceW[i][0] = Double.POSITIVE_INFINITY;
            SymbolicSequence.matriceW[0][i] = Double.POSITIVE_INFINITY;
        }
        SymbolicSequence.matriceW[tailleS][0] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][tailleS] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][0] = 0.0;
        UB = ub_partials[0];
        for (i = 1; i <= tailleS; ++i) {
            int jStart = Math.max(sc, i - w);
            int jStop = Math.min(i + w, tailleT);
            UB = ub_partials[i - 1] + matriceW[i - 1][i - 1];
            SymbolicSequence.matriceW[i][jStart - 1] = Double.POSITIVE_INFINITY;
            boolean found_lower = false;
            for (int j = jStart; j <= jStop; ++j) {
                if (j > ec) {
                    res = matriceW[i][j - 1];
                } else {
                    int indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                    switch (indiceRes) {
                        case 0: {
                            res = matriceW[i - 1][j - 1];
                            break;
                        }
                        case 1: {
                            res = matriceW[i][j - 1];
                            break;
                        }
                        case 2: {
                            res = matriceW[i - 1][j];
                        }
                    }
                }
                SymbolicSequence.matriceW[i][j] = this.sequence[i - 1].squaredDistance(T.sequence[j - 1]) + res;
                if (matriceW[i][j] > UB) {
                    if (!found_lower) {
                        sc = j + 1;
                    }
                    if (j > ec) {
                        SymbolicSequence.matriceW[i][j + 1] = Double.POSITIVE_INFINITY;
                        break;
                    }
                } else {
                    found_lower = true;
                    ec_next = j;
                }
                if (jStop + 1 > tailleT) continue;
                SymbolicSequence.matriceW[i][jStop + 1] = Double.POSITIVE_INFINITY;
            }
            ec = ++ec_next;
        }
        return Math.sqrt(matriceW[tailleS][tailleT]);
    }

    public double PrunedDTW(SymbolicSequence T, int w, double UB) {
        int i;
        ++nDTWExt;
        int tailleS = this.getNbTuples();
        int tailleT = T.getNbTuples();
        double res = 0.0;
        int sc = 1;
        int ec = 1;
        int ec_next = 0;
        for (i = tailleS - 1; i >= 0; --i) {
            SymbolicSequence.matriceW[i][0] = Double.POSITIVE_INFINITY;
            SymbolicSequence.matriceW[0][i] = Double.POSITIVE_INFINITY;
        }
        SymbolicSequence.matriceW[tailleS][0] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][tailleS] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][0] = 0.0;
        for (i = 1; i <= tailleS; ++i) {
            int jStart = Math.max(sc, i - w);
            int jStop = Math.min(i + w, tailleT);
            SymbolicSequence.matriceW[i][jStart - 1] = Double.POSITIVE_INFINITY;
            boolean found_lower = false;
            for (int j = jStart; j <= jStop; ++j) {
                if (j > ec) {
                    res = matriceW[i][j - 1];
                } else {
                    int indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                    switch (indiceRes) {
                        case 0: {
                            res = matriceW[i - 1][j - 1];
                            break;
                        }
                        case 1: {
                            res = matriceW[i][j - 1];
                            break;
                        }
                        case 2: {
                            res = matriceW[i - 1][j];
                        }
                    }
                }
                SymbolicSequence.matriceW[i][j] = this.sequence[i - 1].squaredDistance(T.sequence[j - 1]) + res;
                if (matriceW[i][j] > UB) {
                    if (!found_lower) {
                        sc = j + 1;
                    }
                    if (j > ec) {
                        SymbolicSequence.matriceW[i][j + 1] = Double.POSITIVE_INFINITY;
                        break;
                    }
                } else {
                    found_lower = true;
                    ec_next = j;
                }
                if (jStop + 1 > tailleT) continue;
                SymbolicSequence.matriceW[i][jStop + 1] = Double.POSITIVE_INFINITY;
            }
            ec = ++ec_next;
        }
        return Math.sqrt(matriceW[tailleS][tailleT]);
    }

    public synchronized DTWResult DTWExtResults(SymbolicSequence T, int w) {
        int j;
        int i;
        ++nDTWExt;
        int tailleS = this.getNbTuples();
        int tailleT = T.getNbTuples();
        double res = 0.0;
        SymbolicSequence.matriceW[0][0] = this.sequence[0].squaredDistance(T.sequence[0]);
        SymbolicSequence.minWarpingWindow[0][0] = 0;
        for (i = 1; i < Math.min(tailleS, 1 + w); ++i) {
            SymbolicSequence.matriceW[i][0] = matriceW[i - 1][0] + this.sequence[i].squaredDistance(T.sequence[0]);
            SymbolicSequence.minWarpingWindow[i][0] = i;
        }
        for (j = 1; j < Math.min(tailleT, 1 + w); ++j) {
            SymbolicSequence.matriceW[0][j] = matriceW[0][j - 1] + T.sequence[j].squaredDistance(this.sequence[0]);
            SymbolicSequence.minWarpingWindow[0][j] = j;
        }
        if (j < tailleT) {
            SymbolicSequence.matriceW[0][j] = Double.POSITIVE_INFINITY;
        }
        for (i = 1; i < tailleS; ++i) {
            int jStart = Math.max(1, i - w);
            int jStop = Math.min(tailleT, i + w + 1);
            int indexInftyLeft = i - w - 1;
            if (indexInftyLeft >= 0) {
                SymbolicSequence.matriceW[i][indexInftyLeft] = Double.POSITIVE_INFINITY;
            }
            for (j = jStart; j < jStop; ++j) {
                int indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                int absIJ = Math.abs(i - j);
                switch (indiceRes) {
                    case 0: {
                        res = matriceW[i - 1][j - 1];
                        SymbolicSequence.minWarpingWindow[i][j] = Math.max(absIJ, minWarpingWindow[i - 1][j - 1]);
                        break;
                    }
                    case 1: {
                        res = matriceW[i][j - 1];
                        SymbolicSequence.minWarpingWindow[i][j] = Math.max(absIJ, minWarpingWindow[i][j - 1]);
                        break;
                    }
                    case 2: {
                        res = matriceW[i - 1][j];
                        SymbolicSequence.minWarpingWindow[i][j] = Math.max(absIJ, minWarpingWindow[i - 1][j]);
                    }
                }
                SymbolicSequence.matriceW[i][j] = res + this.sequence[i].squaredDistance(T.sequence[j]);
            }
            if (j >= tailleT) continue;
            SymbolicSequence.matriceW[i][j] = Double.POSITIVE_INFINITY;
        }
        DTWResult resExt = new DTWResult();
        resExt.distance = Math.sqrt(matriceW[tailleS - 1][tailleT - 1]);
        resExt.r = minWarpingWindow[tailleS - 1][tailleT - 1];
        return resExt;
    }

    public synchronized DTWResult PrunedDTWExtResults(SymbolicSequence T, int w) {
        int i;
        ++nDTWExt;
        int tailleS = this.getNbTuples();
        int tailleT = T.getNbTuples();
        double res = 0.0;
        int sc = 1;
        int ec = 1;
        int ec_next = 0;
        double UB = 0.0;
        SymbolicSequence.ub_partials[tailleS] = 0.0;
        for (i = tailleS - 1; i >= 0; --i) {
            SymbolicSequence.ub_partials[i] = ub_partials[i + 1] + this.sequence[i].squaredDistance(T.sequence[i]);
            SymbolicSequence.matriceW[i][0] = Double.POSITIVE_INFINITY;
            SymbolicSequence.matriceW[0][i] = Double.POSITIVE_INFINITY;
            SymbolicSequence.minWarpingWindow[0][i] = i;
            SymbolicSequence.minWarpingWindow[i][0] = i;
        }
        SymbolicSequence.matriceW[tailleS][0] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][tailleS] = Double.POSITIVE_INFINITY;
        SymbolicSequence.matriceW[0][0] = 0.0;
        UB = ub_partials[0];
        for (i = 1; i <= tailleS; ++i) {
            int jStart = Math.max(sc, i - w);
            int jStop = Math.min(i + w, tailleT);
            UB = ub_partials[i - 1] + matriceW[i - 1][i - 1];
            SymbolicSequence.matriceW[i][jStart - 1] = Double.POSITIVE_INFINITY;
            boolean found_lower = false;
            for (int j = jStart; j <= jStop; ++j) {
                int absIJ = Math.abs(i - 1 - (j - 1));
                if (j > ec) {
                    res = matriceW[i][j - 1];
                    SymbolicSequence.minWarpingWindow[i][j] = i == 1 ? i : Math.max(absIJ, minWarpingWindow[i][j - 1]);
                } else {
                    int indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                    switch (indiceRes) {
                        case 0: {
                            res = matriceW[i - 1][j - 1];
                            SymbolicSequence.minWarpingWindow[i][j] = Math.max(absIJ, minWarpingWindow[i - 1][j - 1]);
                            break;
                        }
                        case 1: {
                            res = matriceW[i][j - 1];
                            if (i == 1) {
                                SymbolicSequence.minWarpingWindow[i][j] = i;
                                break;
                            }
                            SymbolicSequence.minWarpingWindow[i][j] = Math.max(absIJ, minWarpingWindow[i][j - 1]);
                            break;
                        }
                        case 2: {
                            res = matriceW[i - 1][j];
                            SymbolicSequence.minWarpingWindow[i][j] = j == 1 ? j : Math.max(absIJ, minWarpingWindow[i - 1][j]);
                        }
                    }
                }
                SymbolicSequence.matriceW[i][j] = this.sequence[i - 1].squaredDistance(T.sequence[j - 1]) + res;
                if (jStop + 1 <= tailleT) {
                    SymbolicSequence.matriceW[i][jStop + 1] = Double.POSITIVE_INFINITY;
                }
                if (matriceW[i][j] > UB) {
                    if (!found_lower) {
                        sc = j + 1;
                    }
                    if (j <= ec) continue;
                    SymbolicSequence.matriceW[i][j + 1] = Double.POSITIVE_INFINITY;
                    break;
                }
                found_lower = true;
                ec_next = j;
            }
            ec = ++ec_next;
        }
        DTWResult resExt = new DTWResult();
        resExt.distance = Math.sqrt(matriceW[tailleS][tailleT]);
        resExt.r = minWarpingWindow[tailleS][tailleT];
        return resExt;
    }

    public synchronized ArrayList<Integer>[] DTWAssociationFromS(SymbolicSequence T) {
        int j;
        int i;
        ArrayList[] association = new ArrayList[this.getNbTuples()];
        for (int i2 = 0; i2 < association.length; ++i2) {
            association[i2] = new ArrayList();
        }
        int tailleS = this.getNbTuples();
        int tailleT = T.getNbTuples();
        double res = 0.0;
        SymbolicSequence.matriceW[0][0] = this.sequence[0].squaredDistance(T.sequence[0]);
        SymbolicSequence.matriceChoix[0][0] = -1;
        SymbolicSequence.optimalPathLength[0][0] = 0;
        for (i = 1; i < tailleS; ++i) {
            SymbolicSequence.matriceW[i][0] = matriceW[i - 1][0] + this.sequence[i].squaredDistance(T.sequence[0]);
            SymbolicSequence.matriceChoix[i][0] = 2;
            SymbolicSequence.optimalPathLength[i][0] = i;
        }
        for (j = 1; j < tailleT; ++j) {
            SymbolicSequence.matriceW[0][j] = matriceW[0][j - 1] + T.sequence[j].squaredDistance(this.sequence[0]);
            SymbolicSequence.matriceChoix[0][j] = 1;
            SymbolicSequence.optimalPathLength[0][j] = j;
        }
        for (i = 1; i < tailleS; ++i) {
            for (j = 1; j < tailleT; ++j) {
                int indiceRes;
                SymbolicSequence.matriceChoix[i][j] = indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                switch (indiceRes) {
                    case 0: {
                        res = matriceW[i - 1][j - 1];
                        SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j - 1] + 1;
                        break;
                    }
                    case 1: {
                        res = matriceW[i][j - 1];
                        SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i][j - 1] + 1;
                        break;
                    }
                    case 2: {
                        res = matriceW[i - 1][j];
                        SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j] + 1;
                    }
                }
                SymbolicSequence.matriceW[i][j] = res + this.sequence[i].squaredDistance(T.sequence[j]);
            }
        }
        int nbTuplesAverageSeq = optimalPathLength[tailleS - 1][tailleT - 1] + 1;
        i = tailleS - 1;
        j = tailleT - 1;
        block15: for (int t = nbTuplesAverageSeq - 1; t >= 0; --t) {
            association[i].add(j);
            switch (matriceChoix[i][j]) {
                case 0: {
                    --i;
                    --j;
                    continue block15;
                }
                case 1: {
                    --j;
                    continue block15;
                }
                case 2: {
                    --i;
                }
            }
        }
        return association;
    }

    protected synchronized ArrayList<Itemset>[] computeAssociations(SymbolicSequence ... tabSequence) {
        ArrayList[] tupleAssociation = new ArrayList[this.getNbTuples()];
        for (int i = 0; i < tupleAssociation.length; ++i) {
            tupleAssociation[i] = new ArrayList(tabSequence.length);
        }
        double res = 0.0;
        int tailleCenter = this.getNbTuples();
        for (SymbolicSequence S : tabSequence) {
            int j;
            int i;
            int tailleT = S.getNbTuples();
            SymbolicSequence.matriceW[0][0] = this.sequence[0].squaredDistance(S.sequence[0]);
            SymbolicSequence.matriceChoix[0][0] = -1;
            SymbolicSequence.optimalPathLength[0][0] = 0;
            for (i = 1; i < tailleCenter; ++i) {
                SymbolicSequence.matriceW[i][0] = matriceW[i - 1][0] + this.sequence[i].squaredDistance(S.sequence[0]);
                SymbolicSequence.matriceChoix[i][0] = 2;
                SymbolicSequence.optimalPathLength[i][0] = i;
            }
            for (j = 1; j < tailleT; ++j) {
                SymbolicSequence.matriceW[0][j] = matriceW[0][j - 1] + S.sequence[j].squaredDistance(this.sequence[0]);
                SymbolicSequence.matriceChoix[0][j] = 1;
                SymbolicSequence.optimalPathLength[0][j] = j;
            }
            for (i = 1; i < tailleCenter; ++i) {
                for (j = 1; j < tailleT; ++j) {
                    int indiceRes;
                    SymbolicSequence.matriceChoix[i][j] = indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                    switch (indiceRes) {
                        case 0: {
                            res = matriceW[i - 1][j - 1];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j - 1] + 1;
                            break;
                        }
                        case 1: {
                            res = matriceW[i][j - 1];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i][j - 1] + 1;
                            break;
                        }
                        case 2: {
                            res = matriceW[i - 1][j];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j] + 1;
                        }
                    }
                    SymbolicSequence.matriceW[i][j] = res + this.sequence[i].squaredDistance(S.sequence[j]);
                }
            }
            int nbTuplesAverageSeq = optimalPathLength[tailleCenter - 1][tailleT - 1] + 1;
            i = tailleCenter - 1;
            j = tailleT - 1;
            block16: for (int t = nbTuplesAverageSeq - 1; t >= 0; --t) {
                tupleAssociation[i].add(S.sequence[j]);
                switch (matriceChoix[i][j]) {
                    case 0: {
                        --i;
                        --j;
                        continue block16;
                    }
                    case 1: {
                        --j;
                        continue block16;
                    }
                    case 2: {
                        --i;
                    }
                }
            }
        }
        return tupleAssociation;
    }

    protected synchronized ArrayList<Itemset>[][] computeAssociationsBySequence(SymbolicSequence ... tabSequence) {
        ArrayList[][] tupleAssociation = new ArrayList[this.sequence.length][tabSequence.length];
        for (int i = 0; i < tupleAssociation.length; ++i) {
            for (int j = 0; j < tupleAssociation[i].length; ++j) {
                tupleAssociation[i][j] = new ArrayList();
            }
        }
        double res = 0.0;
        int sequenceLength = this.sequence.length;
        for (int s = 0; s < tabSequence.length; ++s) {
            int j;
            int i;
            SymbolicSequence S = tabSequence[s];
            int tailleT = S.getNbTuples();
            SymbolicSequence.matriceW[0][0] = this.sequence[0].squaredDistance(S.sequence[0]);
            SymbolicSequence.matriceChoix[0][0] = -1;
            SymbolicSequence.optimalPathLength[0][0] = 0;
            for (i = 1; i < sequenceLength; ++i) {
                SymbolicSequence.matriceW[i][0] = matriceW[i - 1][0] + this.sequence[i].squaredDistance(S.sequence[0]);
                SymbolicSequence.matriceChoix[i][0] = 2;
                SymbolicSequence.optimalPathLength[i][0] = i;
            }
            for (j = 1; j < tailleT; ++j) {
                SymbolicSequence.matriceW[0][j] = matriceW[0][j - 1] + S.sequence[j].squaredDistance(this.sequence[0]);
                SymbolicSequence.matriceChoix[0][j] = 1;
                SymbolicSequence.optimalPathLength[0][j] = j;
            }
            for (i = 1; i < sequenceLength; ++i) {
                for (j = 1; j < tailleT; ++j) {
                    int indiceRes;
                    SymbolicSequence.matriceChoix[i][j] = indiceRes = Tools.ArgMin3(matriceW[i - 1][j - 1], matriceW[i][j - 1], matriceW[i - 1][j]);
                    switch (indiceRes) {
                        case 0: {
                            res = matriceW[i - 1][j - 1];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j - 1] + 1;
                            break;
                        }
                        case 1: {
                            res = matriceW[i][j - 1];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i][j - 1] + 1;
                            break;
                        }
                        case 2: {
                            res = matriceW[i - 1][j];
                            SymbolicSequence.optimalPathLength[i][j] = optimalPathLength[i - 1][j] + 1;
                        }
                    }
                    SymbolicSequence.matriceW[i][j] = res + this.sequence[i].squaredDistance(S.sequence[j]);
                }
            }
            int nbTuplesAverageSeq = optimalPathLength[sequenceLength - 1][tailleT - 1] + 1;
            i = sequenceLength - 1;
            j = tailleT - 1;
            block17: for (int t = nbTuplesAverageSeq - 1; t >= 0; --t) {
                tupleAssociation[i][s].add(S.sequence[j]);
                switch (matriceChoix[i][j]) {
                    case 0: {
                        --i;
                        --j;
                        continue block17;
                    }
                    case 1: {
                        --j;
                        continue block17;
                    }
                    case 2: {
                        --i;
                    }
                }
            }
        }
        return tupleAssociation;
    }

    public String toString() {
        String str = "[";
        for (Itemset t : this.sequence) {
            str = str + "{";
            str = str + t.toString();
            str = str + "}";
        }
        str = str + "]";
        return str;
    }

    public Itemset[] getSequence() {
        return this.sequence;
    }

    public static final double squaredL2(double a, double b) {
        double tmp = a - b;
        return tmp * tmp;
    }

    public static final double squaredL2(String a, String b) {
        return a.equals(b) ? 0.0 : 1.0;
    }

    public static MonoItemSet[] buildSeq(String s) {
        MonoItemSet[] seq = new MonoItemSet[s.length()];
        for (int i = 0; i < seq.length; ++i) {
            seq[i] = new MonoItemSet(s.charAt(i) + "");
        }
        return seq;
    }

    static {
        matriceW = new double[8000][8000];
        matriceChoix = new int[8000][8000];
        optimalPathLength = new int[8000][8000];
        minWarpingWindow = new int[8000][8000];
        ub_partials = new double[8000];
    }
}

