/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.items;

import java.util.Arrays;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;

public class SequenceStatsCache {
    double[][] LEs;
    double[][] UEs;
    double[] mins;
    double[] maxs;
    boolean[] isMinFirst;
    boolean[] isMinLast;
    boolean[] isMaxFirst;
    boolean[] isMaxLast;
    int[] lastWindowComputed;
    int currentWindow;
    SymbolicSequence[] train;
    IndexedDouble[][] indicesSortedByAbsoluteValue;

    public SequenceStatsCache(SymbolicSequence[] train, int startingWindow) {
        this.train = train;
        int nSequences = train.length;
        int length = train[0].getNbTuples();
        this.LEs = new double[nSequences][length];
        this.UEs = new double[nSequences][length];
        this.lastWindowComputed = new int[nSequences];
        Arrays.fill(this.lastWindowComputed, -1);
        this.currentWindow = startingWindow;
        this.mins = new double[nSequences];
        this.maxs = new double[nSequences];
        this.isMinFirst = new boolean[nSequences];
        this.isMinLast = new boolean[nSequences];
        this.isMaxFirst = new boolean[nSequences];
        this.isMaxLast = new boolean[nSequences];
        this.indicesSortedByAbsoluteValue = new IndexedDouble[nSequences][length];
        for (int i = 0; i < train.length; ++i) {
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            int indexMin = -1;
            int indexMax = -1;
            for (int j = 0; j < train[i].getNbTuples(); ++j) {
                double elt = ((MonoDoubleItemSet)train[i].sequence[j]).value;
                if (elt > max) {
                    max = elt;
                    indexMax = j;
                }
                if (elt < min) {
                    min = elt;
                    indexMin = j;
                }
                this.indicesSortedByAbsoluteValue[i][j] = new IndexedDouble(j, Math.abs(elt));
            }
            this.mins[i] = min;
            this.maxs[i] = max;
            this.isMinFirst[i] = indexMin == 0;
            this.isMinLast[i] = indexMin == train[i].getNbTuples() - 1;
            this.isMaxFirst[i] = indexMax == 0;
            this.isMaxLast[i] = indexMax == train[i].getNbTuples() - 1;
            Arrays.sort(this.indicesSortedByAbsoluteValue[i], (v1, v2) -> -Double.compare(v1.value, v2.value));
        }
    }

    public double[] getLE(int i, int w) {
        if (this.lastWindowComputed[i] != w) {
            this.computeLEandUE(i, w);
        }
        return this.LEs[i];
    }

    public double[] getUE(int i, int w) {
        if (this.lastWindowComputed[i] != w) {
            this.computeLEandUE(i, w);
        }
        return this.UEs[i];
    }

    protected void computeLEandUE(int i, int w) {
        this.train[i].LB_KeoghFillUL(w, this.UEs[i], this.LEs[i]);
        this.lastWindowComputed[i] = w;
    }

    public boolean isMinFirst(int i) {
        return this.isMinFirst[i];
    }

    public boolean isMaxFirst(int i) {
        return this.isMaxFirst[i];
    }

    public boolean isMinLast(int i) {
        return this.isMinLast[i];
    }

    public boolean isMaxLast(int i) {
        return this.isMaxLast[i];
    }

    public double getMin(int i) {
        return this.mins[i];
    }

    public double getMax(int i) {
        return this.maxs[i];
    }

    public int getIndexNthHighestVal(int i, int n) {
        return this.indicesSortedByAbsoluteValue[i][n].index;
    }

    class IndexedDouble {
        double value;
        int index;

        public IndexedDouble(int index, double value) {
            this.value = value;
            this.index = index;
        }
    }
}

