/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.items;

import java.util.HashMap;
import timeseriesweka.classifiers.FastWWS.items.Itemset;

public class MonoItemSet
extends Itemset {
    public String letter;

    public MonoItemSet(String letter) {
        this.letter = letter;
    }

    @Override
    public Itemset clone() {
        return new MonoItemSet(new String(this.letter));
    }

    @Override
    public double distance(Itemset o) {
        MonoItemSet mono = (MonoItemSet)o;
        return this.letter.equals(mono.letter) ? 0.0 : 1.0;
    }

    @Override
    public Itemset mean(Itemset[] tab) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int maxCount = 0;
        String maxKey = null;
        for (Itemset itemset : tab) {
            String key = ((MonoItemSet)itemset).letter;
            Integer count = (Integer)map.get(key);
            Integer newCount = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            if (newCount > maxCount) {
                maxCount = newCount;
                maxKey = key;
            }
            map.put(key, newCount);
        }
        return new MonoItemSet(maxKey);
    }

    @Override
    public String toString() {
        return this.letter;
    }
}

