/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.items;

import java.io.Serializable;
import timeseriesweka.classifiers.FastWWS.items.Itemset;

public class MonoDoubleItemSet
extends Itemset
implements Serializable {
    private static final long serialVersionUID = 5103879297281957601L;
    public double value;

    public MonoDoubleItemSet(double value) {
        this.value = value;
    }

    @Override
    public Itemset clone() {
        return new MonoDoubleItemSet(this.value);
    }

    @Override
    public double distance(Itemset o) {
        MonoDoubleItemSet o1 = (MonoDoubleItemSet)o;
        return Math.abs(o1.value - this.value);
    }

    @Override
    public Itemset mean(Itemset[] tab) {
        if (tab.length < 1) {
            throw new RuntimeException("Empty tab");
        }
        double sum = 0.0;
        for (Itemset itemset : tab) {
            MonoDoubleItemSet item = (MonoDoubleItemSet)itemset;
            sum += item.value;
        }
        return new MonoDoubleItemSet(sum / (double)tab.length);
    }

    @Override
    public String toString() {
        return new Double(this.value).toString();
    }

    public double getValue() {
        return this.value;
    }
}

