/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.items;

import timeseriesweka.classifiers.FastWWS.items.DTWResult;
import timeseriesweka.classifiers.FastWWS.items.MonoDoubleItemSet;
import timeseriesweka.classifiers.FastWWS.items.SequenceStatsCache;
import timeseriesweka.classifiers.FastWWS.sequences.SymbolicSequence;

public class LazyAssessNN
implements Comparable<LazyAssessNN> {
    protected static final int RIEN = -1;
    protected static final int DIAGONALE = 0;
    protected static final int GAUCHE = 1;
    protected static final int HAUT = 2;
    SequenceStatsCache cache;
    SymbolicSequence query;
    SymbolicSequence reference;
    public int indexQuery;
    public int indexReference;
    int indexStoppedLB;
    int oldIndexStoppedLB;
    int currentW;
    int minWindowValidityFullDTW;
    int nOperationsLBKim;
    double minDist;
    double LBKeogh1;
    double LBKeogh2;
    double bestMinDist;
    double EuclideanDist;
    LBStatus status;
    public static double[] ubPartials;

    public LazyAssessNN(SymbolicSequence query, int index, SymbolicSequence reference, int indexReference, SequenceStatsCache cache) {
        if (index < indexReference) {
            this.query = query;
            this.indexQuery = index;
            this.reference = reference;
            this.indexReference = indexReference;
        } else {
            this.query = reference;
            this.indexQuery = indexReference;
            this.reference = query;
            this.indexReference = index;
        }
        this.minDist = 0.0;
        this.cache = cache;
        this.tryLBKim();
        this.bestMinDist = this.minDist;
        this.status = LBStatus.LB_Kim;
    }

    public LazyAssessNN(SequenceStatsCache cache) {
        this.cache = cache;
    }

    public void set(SymbolicSequence query, int index, SymbolicSequence reference, int indexReference) {
        this.oldIndexStoppedLB = 0;
        this.indexStoppedLB = 0;
        this.currentW = 0;
        this.minWindowValidityFullDTW = 0;
        this.nOperationsLBKim = 0;
        this.LBKeogh2 = 0.0;
        this.LBKeogh1 = 0.0;
        if (index < indexReference) {
            this.query = query;
            this.indexQuery = index;
            this.reference = reference;
            this.indexReference = indexReference;
        } else {
            this.query = reference;
            this.indexQuery = indexReference;
            this.reference = query;
            this.indexReference = index;
        }
        this.minDist = 0.0;
        this.tryLBKim();
        this.bestMinDist = this.minDist;
        this.status = LBStatus.LB_Kim;
    }

    public void initUBPartial() {
        ubPartials = new double[this.query.getNbTuples() + 1];
    }

    public void setBestMinDist(double bestMinDist) {
        this.bestMinDist = bestMinDist;
    }

    public void setCurrentW(int currentW) {
        if (this.currentW != currentW) {
            this.currentW = currentW;
            if (this.status == LBStatus.Full_DTW) {
                this.status = this.currentW >= this.minWindowValidityFullDTW ? LBStatus.Full_DTW : LBStatus.Previous_Window_DTW;
            } else {
                this.status = LBStatus.Previous_Window_LB;
                this.oldIndexStoppedLB = this.indexStoppedLB;
            }
        }
    }

    public RefineReturnType tryEuclidean(double scoreToBeat) {
        if (this.bestMinDist >= scoreToBeat) {
            return RefineReturnType.Pruned_with_LB;
        }
        if (this.EuclideanDist >= scoreToBeat) {
            return RefineReturnType.Pruned_with_DTW;
        }
        LazyAssessNN.ubPartials[this.query.getNbTuples()] = 0.0;
        for (int i = this.query.getNbTuples() - 1; i >= 0; --i) {
            LazyAssessNN.ubPartials[i] = ubPartials[i + 1] + this.query.getItem(i).squaredDistance(this.reference.getItem(i));
        }
        this.EuclideanDist = ubPartials[0];
        return RefineReturnType.New_best;
    }

    protected void tryLBKim() {
        double diffFirsts = this.query.sequence[0].squaredDistance(this.reference.sequence[0]);
        double diffLasts = this.query.sequence[this.query.getNbTuples() - 1].squaredDistance(this.reference.sequence[this.reference.getNbTuples() - 1]);
        this.minDist = diffFirsts + diffLasts;
        this.nOperationsLBKim = 2;
        if (!(this.cache.isMinFirst(this.indexQuery) || this.cache.isMinFirst(this.indexReference) || this.cache.isMinLast(this.indexQuery) || this.cache.isMinLast(this.indexReference))) {
            double diffMin = this.cache.getMin(this.indexQuery) - this.cache.getMin(this.indexReference);
            this.minDist += diffMin * diffMin;
            ++this.nOperationsLBKim;
        }
        if (!(this.cache.isMaxFirst(this.indexQuery) || this.cache.isMaxFirst(this.indexReference) || this.cache.isMaxLast(this.indexQuery) || this.cache.isMaxLast(this.indexReference))) {
            double diffMax = this.cache.getMax(this.indexQuery) - this.cache.getMax(this.indexReference);
            this.minDist += diffMax * diffMax;
            ++this.nOperationsLBKim;
        }
        this.status = LBStatus.LB_Kim;
    }

    protected void tryFullLBKeoghQR() {
        int length = this.query.sequence.length;
        double[] LEQ = this.cache.getLE(this.indexQuery, this.currentW);
        double[] UEQ = this.cache.getUE(this.indexQuery, this.currentW);
        this.minDist = 0.0;
        this.indexStoppedLB = 0;
        while (this.indexStoppedLB < length) {
            double diff;
            int index;
            double c = ((MonoDoubleItemSet)this.reference.sequence[index]).value;
            index = this.cache.getIndexNthHighestVal(this.indexReference, this.indexStoppedLB);
            if (c < LEQ[index]) {
                diff = LEQ[index] - c;
                this.minDist += diff * diff;
            } else if (UEQ[index] < c) {
                diff = UEQ[index] - c;
                this.minDist += diff * diff;
            }
            ++this.indexStoppedLB;
        }
    }

    protected void tryFullLBKeoghRQ() {
        int length = this.reference.sequence.length;
        double[] LER = this.cache.getLE(this.indexReference, this.currentW);
        double[] UER = this.cache.getUE(this.indexReference, this.currentW);
        this.minDist = 0.0;
        this.indexStoppedLB = 0;
        while (this.indexStoppedLB < length) {
            double diff;
            int index;
            double c = ((MonoDoubleItemSet)this.query.sequence[index]).value;
            index = this.cache.getIndexNthHighestVal(this.indexQuery, this.indexStoppedLB);
            if (c < LER[index]) {
                diff = LER[index] - c;
                this.minDist += diff * diff;
            } else if (UER[index] < c) {
                diff = UER[index] - c;
                this.minDist += diff * diff;
            }
            ++this.indexStoppedLB;
        }
    }

    public RefineReturnType tryToBeat(double scoreToBeat, int w) {
        this.setCurrentW(w);
        switch (this.status) {
            case Previous_Window_LB: 
            case Previous_Window_DTW: 
            case LB_Kim: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.indexStoppedLB = 0;
                this.minDist = 0.0;
            }
            case Partial_LB_KeoghQR: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.tryFullLBKeoghQR();
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                if (this.bestMinDist >= scoreToBeat) {
                    if (this.indexStoppedLB < this.query.getNbTuples()) {
                        this.status = LBStatus.Partial_LB_KeoghQR;
                    } else {
                        this.LBKeogh1 = this.minDist;
                        this.status = LBStatus.Full_LB_KeoghQR;
                    }
                    return RefineReturnType.Pruned_with_LB;
                }
                this.status = LBStatus.Full_LB_KeoghQR;
            }
            case Full_LB_KeoghQR: {
                this.indexStoppedLB = 0;
                this.minDist = 0.0;
            }
            case Partial_LB_KeoghRQ: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.tryFullLBKeoghRQ();
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                if (this.bestMinDist >= scoreToBeat) {
                    if (this.indexStoppedLB < this.reference.getNbTuples()) {
                        this.status = LBStatus.Partial_LB_KeoghRQ;
                    } else {
                        this.LBKeogh2 = this.minDist;
                        this.status = LBStatus.Full_LB_KeoghRQ;
                    }
                    return RefineReturnType.Pruned_with_LB;
                }
                this.status = LBStatus.Full_LB_KeoghRQ;
            }
            case Full_LB_KeoghRQ: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                DTWResult res = this.query.DTWExtResults(this.reference, this.currentW);
                this.minDist = res.distance * res.distance;
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                this.status = LBStatus.Full_DTW;
                this.minWindowValidityFullDTW = res.r;
            }
            case Full_DTW: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_DTW;
                }
                return RefineReturnType.New_best;
            }
        }
        throw new RuntimeException("Case not managed");
    }

    public RefineReturnType tryToBeatPrunedDTW(double scoreToBeat, int w) {
        this.setCurrentW(w);
        switch (this.status) {
            case Previous_Window_LB: 
            case Previous_Window_DTW: 
            case LB_Kim: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.indexStoppedLB = 0;
                this.minDist = 0.0;
            }
            case Partial_LB_KeoghQR: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.tryFullLBKeoghQR();
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                if (this.bestMinDist >= scoreToBeat) {
                    if (this.indexStoppedLB < this.query.getNbTuples()) {
                        this.status = LBStatus.Partial_LB_KeoghQR;
                    } else {
                        this.LBKeogh1 = this.minDist;
                        this.status = LBStatus.Full_LB_KeoghQR;
                    }
                    return RefineReturnType.Pruned_with_LB;
                }
                this.status = LBStatus.Full_LB_KeoghQR;
            }
            case Full_LB_KeoghQR: {
                this.indexStoppedLB = 0;
                this.minDist = 0.0;
            }
            case Partial_LB_KeoghRQ: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                this.tryFullLBKeoghRQ();
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                if (this.bestMinDist >= scoreToBeat) {
                    if (this.indexStoppedLB < this.reference.getNbTuples()) {
                        this.status = LBStatus.Partial_LB_KeoghRQ;
                    } else {
                        this.LBKeogh2 = this.minDist;
                        this.status = LBStatus.Full_LB_KeoghRQ;
                    }
                    return RefineReturnType.Pruned_with_LB;
                }
                this.status = LBStatus.Full_LB_KeoghRQ;
            }
            case Full_LB_KeoghRQ: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_LB;
                }
                DTWResult res = this.query.PrunedDTWExtResults(this.reference, this.currentW);
                this.minDist = res.distance * res.distance;
                if (this.minDist > this.bestMinDist) {
                    this.bestMinDist = this.minDist;
                }
                this.status = LBStatus.Full_DTW;
                this.minWindowValidityFullDTW = res.r;
            }
            case Full_DTW: {
                if (this.bestMinDist >= scoreToBeat) {
                    return RefineReturnType.Pruned_with_DTW;
                }
                return RefineReturnType.New_best;
            }
        }
        throw new RuntimeException("Case not managed");
    }

    public String toString() {
        return "" + this.indexQuery + " - " + this.indexReference + " - " + this.bestMinDist;
    }

    public int getOtherIndex(int index) {
        if (index == this.indexQuery) {
            return this.indexReference;
        }
        return this.indexQuery;
    }

    public SymbolicSequence getSequenceForOtherIndex(int index) {
        if (index == this.indexQuery) {
            return this.reference;
        }
        return this.query;
    }

    public double getDistance(int window) {
        if (this.status == LBStatus.Full_DTW && this.minWindowValidityFullDTW <= window) {
            return this.minDist;
        }
        throw new RuntimeException("Shouldn't call getDistance if not sure there is a valid already-computed DTW distance");
    }

    public int getMinWindowValidityForFullDistance() {
        if (this.status == LBStatus.Full_DTW) {
            return this.minWindowValidityFullDTW;
        }
        throw new RuntimeException("Shouldn't call getDistance if not sure there is a valid already-computed DTW distance");
    }

    public double[] getUBPartial() {
        return ubPartials;
    }

    public double getEuclideanDistance() {
        return this.EuclideanDist;
    }

    @Override
    public int compareTo(LazyAssessNN o) {
        int res = this.compare(o);
        return res;
    }

    protected int compare(LazyAssessNN o) {
        double num1 = this.getDoubleValueForRanking();
        double num2 = o.getDoubleValueForRanking();
        return Double.compare(num1, num2);
    }

    protected double getDoubleValueForRanking() {
        double thisD = this.bestMinDist;
        switch (this.status) {
            case Full_LB_KeoghQR: 
            case Full_LB_KeoghRQ: 
            case Full_DTW: {
                return thisD / (double)this.query.getNbTuples();
            }
            case LB_Kim: {
                return thisD / (double)this.nOperationsLBKim;
            }
            case Partial_LB_KeoghQR: 
            case Partial_LB_KeoghRQ: {
                return thisD / (double)this.indexStoppedLB;
            }
            case Previous_Window_DTW: {
                return 0.8 * thisD / (double)this.query.getNbTuples();
            }
            case Previous_Window_LB: {
                if (this.indexStoppedLB == 0) {
                    return thisD / (double)this.nOperationsLBKim;
                }
                return thisD / (double)this.oldIndexStoppedLB;
            }
        }
        throw new RuntimeException("shouldn't come here");
    }

    public boolean equals(Object o) {
        LazyAssessNN d = (LazyAssessNN)o;
        return this.indexQuery == d.indexQuery && this.indexReference == d.indexReference;
    }

    public LBStatus getStatus() {
        return this.status;
    }

    public void setFullDistStatus() {
        this.status = LBStatus.Full_DTW;
    }

    public double getBestLB() {
        return this.bestMinDist;
    }

    public static enum LBStatus {
        LB_Kim,
        Partial_LB_KeoghQR,
        Full_LB_KeoghQR,
        Partial_LB_KeoghRQ,
        Full_LB_KeoghRQ,
        Previous_Window_LB,
        Previous_Window_DTW,
        Full_DTW;

    }

    public static enum RefineReturnType {
        Pruned_with_LB,
        Pruned_with_DTW,
        New_best;

    }
}

