/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.items;

import java.io.File;
import timeseriesweka.classifiers.FastWWS.tools.UCR2CSV;
import weka.core.Instances;
import weka.core.converters.CSVLoader;

public class ExperimentsLauncher {
    public static String username = System.getProperty("user.name");
    long startTime;
    long endTime;
    long duration;

    public static Instances[] readTrainAndTest(String path, String name) {
        File trainFile = new File(path + name + "/" + name + "_TRAIN");
        if (!new File(trainFile.getAbsolutePath() + ".csv").exists()) {
            UCR2CSV.run(trainFile, new File(trainFile.getAbsolutePath() + ".csv"));
        }
        trainFile = new File(trainFile.getAbsolutePath() + ".csv");
        File testFile = new File(path + name + "/" + name + "_TEST");
        if (!new File(testFile.getAbsolutePath() + ".csv").exists()) {
            UCR2CSV.run(testFile, new File(testFile.getAbsolutePath() + ".csv"));
        }
        testFile = new File(testFile.getAbsolutePath() + ".csv");
        CSVLoader loader = new CSVLoader();
        Instances trainDataset = null;
        Instances testDataset = null;
        try {
            loader.setFile(trainFile);
            loader.setNominalAttributes("first");
            trainDataset = loader.getDataSet();
            trainDataset.setClassIndex(0);
            loader.setFile(testFile);
            loader.setNominalAttributes("first");
            testDataset = loader.getDataSet();
            testDataset.setClassIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Instances[]{trainDataset, testDataset};
    }

    public static Instances readAllInOne(String path, String name) {
        File trainFile = new File(path + name + "/" + name + "_TRAIN");
        if (!new File(trainFile.getAbsolutePath() + ".csv").exists()) {
            UCR2CSV.run(trainFile, new File(trainFile.getAbsolutePath() + ".csv"));
        }
        trainFile = new File(trainFile.getAbsolutePath() + ".csv");
        File testFile = new File(path + name + "/" + name + "_TEST");
        if (!new File(testFile.getAbsolutePath() + ".csv").exists()) {
            UCR2CSV.run(testFile, new File(testFile.getAbsolutePath() + ".csv"));
        }
        testFile = new File(testFile.getAbsolutePath() + ".csv");
        CSVLoader loader = new CSVLoader();
        Instances trainDataset = null;
        Instances testDataset = null;
        try {
            loader.setFile(trainFile);
            loader.setNominalAttributes("first");
            trainDataset = loader.getDataSet();
            trainDataset.setClassIndex(0);
            loader.setFile(testFile);
            loader.setNominalAttributes("first");
            testDataset = loader.getDataSet();
            testDataset.setClassIndex(0);
            for (int i = 0; i < testDataset.numInstances(); ++i) {
                trainDataset.add(testDataset.instance(i));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return trainDataset;
    }
}

