/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.experiments;

import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import timeseriesweka.classifiers.FastWWS.items.ExperimentsLauncher;
import timeseriesweka.classifiers.FastWWS.tools.Sampling;
import timeseriesweka.classifiers.FastWWS.tools.UCRArchive;
import timeseriesweka.classifiers.FastWWS.windowSearcher.FastWWS;
import timeseriesweka.classifiers.FastWWS.windowSearcher.FastWWSPrunedDTW;
import weka.classifiers.Evaluation;
import weka.core.Instances;

public class UCR_FastWWSPrunedDTW {
    private static String osName;
    private static String datasetName;
    private static String username;
    private static String projectPath;
    private static String datasetPath;
    private static String resDir;
    private static String sampleType;
    private static String method;
    private static int bestWarpingWindow;
    private static double bestScore;
    private static int nbRuns;
    private static boolean firstRun;

    public static void main(String[] args) throws Exception {
        sampleType = "Single";
        datasetName = "ElectricDevices";
        method = "FastWWSearch-PrunedDTW";
        osName = System.getProperty("os.name");
        username = System.getProperty("user.name");
        if (osName.contains("Window")) {
            projectPath = "C:/Users/" + username + "/workspace/SDM18/";
            datasetPath = sampleType.equals("New") ? "C:/Users/" + username + "/workspace/Dataset/TSC_Problems/" : "C:/Users/" + username + "/workspace/Dataset/UCR_Time_Series_Archive/";
        } else {
            projectPath = "/home/" + username + "/workspace/SDM18/";
            datasetPath = sampleType.equals("New") ? "/home/" + username + "/workspace/Dataset/TSC_Problems/" : "/home/" + username + "/workspace/Dataset/UCR_Time_Series_Archive/";
        }
        if (args.length >= 1) {
            projectPath = args[0];
        }
        if (args.length >= 2) {
            datasetPath = args[1];
        }
        if (args.length >= 3) {
            sampleType = args[2];
        }
        if (sampleType.equals("Single") && args.length >= 4) {
            datasetName = args[3];
            if (args.length >= 5) {
                nbRuns = Integer.parseInt(args[4]);
            }
        } else if (args.length >= 4) {
            nbRuns = Integer.parseInt(args[3]);
        }
        if (sampleType.equals("Single")) {
            System.out.println("Find best warping window with " + method + " on " + datasetName + " dataset -- " + nbRuns + " runs");
        } else {
            System.out.println("Find best warping window with " + method + " on " + sampleType + " dataset -- " + nbRuns + " runs");
        }
        switch (sampleType) {
            case "Sorted": {
                System.out.println("Find best warping window with Sorted UCR datasets");
                for (int j = 0; j < UCRArchive.sortedDataset.length; ++j) {
                    datasetName = UCRArchive.sortedDataset[j];
                    UCR_FastWWSPrunedDTW.singleProblem(datasetName);
                }
                break;
            }
            case "Small": {
                System.out.println("Find best warping window with Small UCR datasets");
                for (int j = 0; j < UCRArchive.smallDataset.length; ++j) {
                    datasetName = UCRArchive.smallDataset[j];
                    UCR_FastWWSPrunedDTW.singleProblem(datasetName);
                }
                break;
            }
            case "New": {
                System.out.println("Find best warping window with New TSC datasets");
                for (int j = 0; j < UCRArchive.newTSCProblems.length; ++j) {
                    datasetName = UCRArchive.newTSCProblems[j];
                    UCR_FastWWSPrunedDTW.singleProblem(datasetName);
                }
                break;
            }
            case "All": {
                System.out.println("Find best warping window with " + datasetName + " dataset");
                File rep = new File(datasetPath);
                Object[] listData = rep.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                });
                Arrays.sort(listData);
                for (Object dataRep : listData) {
                    datasetName = ((File)dataRep).getName();
                    UCR_FastWWSPrunedDTW.singleProblem(datasetName);
                }
                break;
            }
            case "Single": {
                System.out.println("Find best warping window with " + datasetName + " dataset");
                UCR_FastWWSPrunedDTW.singleProblem(datasetName);
            }
        }
    }

    private static void singleProblem(String datasetName) throws Exception {
        resDir = projectPath + "outputs/Incorporate_PrunedDTW/" + datasetName + "/";
        File dir = new File(resDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        double[][] searchTimes = new double[2][nbRuns];
        double speedUp = 0.0;
        double avgFastWWSTime = 0.0;
        double avgFastWWSSDM16Time = 0.0;
        System.out.println("Processing: " + datasetName);
        Instances[] data = ExperimentsLauncher.readTrainAndTest(datasetPath, datasetName);
        Instances train = data[0];
        Instances test = data[1];
        if (!firstRun) {
            FastWWS tempClassifier = new FastWWS(datasetName);
            tempClassifier.setResDir(resDir);
            tempClassifier.setType(method);
            tempClassifier.buildClassifier(train);
            firstRun = true;
        }
        for (int i = 0; i < nbRuns; ++i) {
            train = Sampling.random(train);
            method = "FastWWSearch";
            System.out.println("Run " + i + ", Launching " + method);
            FastWWS fastwwsClassifier = new FastWWS(datasetName);
            fastwwsClassifier.setResDir(resDir);
            fastwwsClassifier.setType(method);
            long start = System.nanoTime();
            fastwwsClassifier.buildClassifier(train);
            long stop = System.nanoTime();
            double searchTime = (double)(stop - start) / 1.0E9;
            System.out.println(searchTime + " s");
            searchTimes[0][i] = searchTime;
            avgFastWWSTime += searchTime;
            bestWarpingWindow = fastwwsClassifier.getBestWin();
            bestScore = fastwwsClassifier.getBestScore();
            Evaluation eval = new Evaluation(train);
            eval.evaluateModel(fastwwsClassifier, test, new Object[0]);
            System.out.println(eval.errorRate());
            UCR_FastWWSPrunedDTW.saveSearchTime(searchTime, eval.errorRate());
            method = "FastWWSearch-PrunedDTW";
            System.out.println("Run " + i + ", Launching FastWWS with SDM16");
            FastWWSPrunedDTW fastwwsSDM16Classifier = new FastWWSPrunedDTW(datasetName);
            fastwwsSDM16Classifier.setResDir(resDir);
            fastwwsSDM16Classifier.setType(method);
            start = System.nanoTime();
            fastwwsSDM16Classifier.buildClassifier(train);
            stop = System.nanoTime();
            searchTime = (double)(stop - start) / 1.0E9;
            System.out.println(searchTime + " s");
            searchTimes[1][i] = searchTime;
            avgFastWWSSDM16Time += searchTime;
            bestWarpingWindow = fastwwsSDM16Classifier.getBestWin();
            bestScore = fastwwsSDM16Classifier.getBestScore();
            eval = new Evaluation(train);
            eval.evaluateModel(fastwwsSDM16Classifier, test, new Object[0]);
            System.out.println(eval.errorRate());
            UCR_FastWWSPrunedDTW.saveSearchTime(searchTime, eval.errorRate());
            speedUp += searchTimes[0][i] / searchTimes[1][i];
        }
        System.out.println("Average FastWWS Time: " + avgFastWWSTime / (double)nbRuns + "s");
        System.out.println("Average FastWWS with SDM16 Time: " + avgFastWWSSDM16Time / (double)nbRuns + "s");
        System.out.println("Average Speedup: " + speedUp / (double)nbRuns);
    }

    private static void saveSearchTime(double searchTime, double error) {
        String fileName = resDir + datasetName + "_result_" + method + ".csv";
        boolean append = false;
        File file = new File(fileName);
        if (file.exists()) {
            append = true;
        }
        try {
            FileWriter out = new FileWriter(fileName, append);
            if (!append) {
                out.append("SearchTime(s),BestWin,BestScore,TestError\n");
            }
            out.append(searchTime + "," + bestWarpingWindow + "," + bestScore + "," + error + "\n");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        nbRuns = 1;
        firstRun = false;
    }
}

