/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS.experiments;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import timeseriesweka.classifiers.FastWWS.items.ExperimentsLauncher;
import timeseriesweka.classifiers.FastWWS.tools.Sampling;
import timeseriesweka.classifiers.FastWWS.windowSearcher.FastWWS;
import timeseriesweka.classifiers.FastWWS.windowSearcher.LbKeoghPrunedDTW;
import timeseriesweka.classifiers.FastWWS.windowSearcher.Trillion;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;
import weka.core.Instances;

public class ScalabilityExperiment {
    private static int estimate = 10000;
    private static String osName;
    private static String datasetName;
    private static String username;
    private static String projectPath;
    private static String datasetPath;
    private static String resDir;
    private static String method;
    private static int[] sampleTrains;

    public static void main(String[] args) throws Exception {
        datasetName = "SITS1M_fold1";
        method = "FastWWSearch";
        osName = System.getProperty("os.name");
        username = System.getProperty("user.name");
        if (osName.contains("Window")) {
            projectPath = "C:/Users/" + username + "/workspace/SDM18/";
            datasetPath = "C:/Users/" + username + "/workspace/Dataset/SITS_2006_NDVI_C/";
        } else {
            projectPath = "/home/" + username + "/workspace/SDM18/";
            datasetPath = "/home/" + username + "/workspace/Dataset/SITS_2006_NDVI_C/";
        }
        long heapMaxSize = Runtime.getRuntime().maxMemory();
        long heapFreeSize = Runtime.getRuntime().freeMemory();
        System.out.println("Heap Size -- Free " + 1.0 * (double)heapFreeSize / 1000000.0 + ", " + 1.0 * (double)heapMaxSize / 1000000.0);
        if (args.length >= 1) {
            projectPath = args[0];
        }
        if (args.length >= 2) {
            datasetPath = args[1];
        }
        if (args.length >= 3) {
            method = args[2];
        }
        System.out.println("Scalability experiment with " + method);
        Instances allData = ScalabilityExperiment.loadAllData();
        switch (method) {
            case "LBKeogh": {
                ScalabilityExperiment.keogh(allData);
                break;
            }
            case "UCRSuite": {
                ScalabilityExperiment.ucrSuite(allData);
                break;
            }
            case "LBKeogh-PrunedDTW": {
                ScalabilityExperiment.keoghPrunedDTW(allData);
                break;
            }
            case "FastWWSearch": {
                ScalabilityExperiment.fastWWS(allData);
            }
        }
    }

    private static Instances loadAllData() {
        resDir = projectPath + "outputs/Scaling/";
        File dir = new File(resDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        System.out.println("Processing: " + datasetName);
        Instances data = ExperimentsLauncher.readAllInOne(datasetPath, datasetName);
        return data;
    }

    public static void fastWWS(Instances data) {
        System.out.println(method);
        double[] timeTaken = new double[sampleTrains.length];
        int i = 0;
        for (int sampleSize : sampleTrains) {
            double searchTime = ScalabilityExperiment.fastWWS(data, sampleSize);
            timeTaken[i++] = searchTime;
        }
    }

    public static double fastWWS(Instances data, int sampleSize) {
        double searchTime = 0.0;
        try {
            Instances newTrain = Sampling.sample(data, sampleSize);
            System.out.println("Size: " + sampleSize + ", Launching FastWWS");
            FastWWS classifier = new FastWWS(datasetName);
            classifier.setResDir(resDir);
            classifier.setType(method);
            long start = System.nanoTime();
            classifier.buildClassifier(newTrain);
            long stop = System.nanoTime();
            searchTime = 1.0 * ((double)(stop - start) / 1.0E9);
            ScalabilityExperiment.saveSearchTime(sampleSize, searchTime);
            System.out.println("Size: " + sampleSize + ", " + searchTime + " s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchTime;
    }

    public static void keogh(Instances data) {
        System.out.println(method);
        double[] timeTaken = new double[sampleTrains.length];
        int i = 0;
        for (int sampleSize : sampleTrains) {
            double searchTime = ScalabilityExperiment.keogh(data, sampleSize);
            timeTaken[i++] = searchTime;
        }
    }

    public static double keogh(Instances data, int sampleSize) {
        double share = 1.0;
        double searchTime = 0.0;
        WindowSearcher classifier = new WindowSearcher(datasetName);
        classifier.setResDir(resDir);
        classifier.setType(method);
        try {
            long stop;
            long start;
            Instances newTrain = Sampling.sample(data, sampleSize);
            System.out.println("Size: " + sampleSize + ", Launching Keogh");
            if (sampleSize < estimate + 1) {
                start = System.nanoTime();
                classifier.buildClassifier(newTrain);
                stop = System.nanoTime();
            } else {
                start = System.nanoTime();
                classifier.buildClassifierEstimate(newTrain, estimate);
                stop = System.nanoTime();
                share = 1.0 * (double)(estimate + 1) / (double)newTrain.numInstances();
            }
            searchTime = 1.0 * ((double)(stop - start) / 1.0E9);
            ScalabilityExperiment.saveSearchTime(sampleSize, searchTime /= share);
            System.out.println("Size: " + sampleSize + ", " + searchTime + " s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchTime;
    }

    public static void ucrSuite(Instances data) {
        System.out.println(method);
        double[] timeTaken = new double[sampleTrains.length];
        int i = 0;
        for (int sampleSize : sampleTrains) {
            double searchTime = ScalabilityExperiment.ucrSuite(data, sampleSize);
            timeTaken[i++] = searchTime;
        }
    }

    public static double ucrSuite(Instances data, int sampleSize) {
        double share = 1.0;
        double searchTime = 0.0;
        try {
            long stop;
            long start;
            Instances newTrain = Sampling.sample(data, sampleSize);
            System.out.println("Size: " + sampleSize + ", Launching KDD12");
            if (sampleSize < estimate + 1) {
                Trillion classifier = new Trillion(datasetName);
                classifier.setResDir(resDir);
                classifier.setType(method);
                start = System.nanoTime();
                classifier.buildClassifier(newTrain);
                stop = System.nanoTime();
            } else {
                Trillion classifier = new Trillion(datasetName);
                classifier.setResDir(resDir);
                classifier.setType(method);
                start = System.nanoTime();
                classifier.buildClassifierEstimate(newTrain, estimate);
                stop = System.nanoTime();
                share = 1.0 * (double)(estimate + 1) / (double)newTrain.numInstances();
                System.out.println("Share: " + share);
            }
            searchTime = 1.0 * ((double)(stop - start) / 1.0E9);
            ScalabilityExperiment.saveSearchTime(sampleSize, searchTime /= share);
            System.out.println("Size: " + sampleSize + ", " + searchTime + " s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchTime;
    }

    public static void keoghPrunedDTW(Instances data) {
        System.out.println(method);
        double[] timeTaken = new double[sampleTrains.length];
        int i = 0;
        for (int sampleSize : sampleTrains) {
            double searchTime = ScalabilityExperiment.keoghPrunedDTW(data, sampleSize);
            timeTaken[i++] = searchTime;
        }
    }

    public static double keoghPrunedDTW(Instances data, int sampleSize) {
        double share = 1.0;
        double searchTime = 0.0;
        LbKeoghPrunedDTW classifier = new LbKeoghPrunedDTW(datasetName);
        classifier.setResDir(resDir);
        classifier.setType(method);
        try {
            long stop;
            long start;
            Instances newTrain = Sampling.sample(data, sampleSize);
            System.out.println("Size: " + sampleSize + ", Launching SDM16");
            if (sampleSize < estimate + 1) {
                start = System.nanoTime();
                classifier.buildClassifier(newTrain);
                stop = System.nanoTime();
            } else {
                start = System.nanoTime();
                classifier.buildClassifierEstimate(newTrain, estimate);
                stop = System.nanoTime();
                share = 1.0 * (double)(estimate + 1) / (double)newTrain.numInstances();
            }
            searchTime = 1.0 * ((double)(stop - start) / 1.0E9);
            ScalabilityExperiment.saveSearchTime(sampleSize, searchTime /= share);
            System.out.println("Size: " + sampleSize + ", " + searchTime + " s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return searchTime;
    }

    private static void saveSearchTime(int sampleSize, double searchTime) {
        String fileName = resDir + "scaling_result_" + method + ".csv";
        boolean append = false;
        File file = new File(fileName);
        if (file.exists()) {
            append = true;
        }
        try {
            FileWriter out = new FileWriter(fileName, append);
            if (!append) {
                out.append("SampleSize,SearchTime(s)\n");
            }
            out.append(sampleSize + "," + searchTime + "\n");
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        sampleTrains = new int[]{100, 100, 250, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 500000, 1000000};
    }
}

