/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers.FastWWS;

import java.util.ArrayList;
import timeseriesweka.classifiers.FastWWS.windowSearcher.FastWWSByPercent;
import timeseriesweka.classifiers.FastWWS.windowSearcher.WindowSearcher;
import utilities.ClassifierResults;
import utilities.SaveParameterInfo;
import weka.classifiers.AbstractClassifier;
import weka.core.Instance;
import weka.core.Instances;

public class FastDTWWrapper
extends AbstractClassifier
implements SaveParameterInfo {
    WindowSearcher ws;
    protected ArrayList<Double> buildTimes;
    protected ClassifierResults res = new ClassifierResults();

    public FastDTWWrapper() {
        this.ws = new FastWWSByPercent();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        long usedBytes;
        long startTime = System.currentTimeMillis();
        this.ws.buildClassifier(data);
        this.res.buildTime = System.currentTimeMillis() - startTime;
        Runtime rt = Runtime.getRuntime();
        this.res.memory = usedBytes = rt.totalMemory() - rt.freeMemory();
    }

    @Override
    public double classifyInstance(Instance data) throws Exception {
        return this.ws.classifyInstance(data);
    }

    @Override
    public String getParameters() {
        String result = "BuildTime," + this.res.buildTime + ",CVAcc," + this.res.acc + ",Memory," + this.res.memory;
        result = result + ",WindowSize," + this.ws.getBestWin() + ",Score," + this.ws.getBestScore();
        return result;
    }
}

