/*
 * Decompiled with CFR 0.152.
 */
package timeseriesweka.classifiers;

import timeseriesweka.classifiers.AbstractClassifierWithTrainingData;
import timeseriesweka.filters.BagOfPatternsFilter;
import timeseriesweka.filters.SAX;
import utilities.ClassifierTools;
import weka.classifiers.lazy.kNN;
import weka.core.Capabilities;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.TechnicalInformation;

public class BagOfPatterns
extends AbstractClassifierWithTrainingData {
    public Instances matrix;
    public kNN knn;
    private BagOfPatternsFilter bop;
    private int PAA_intervalsPerWindow;
    private int SAX_alphabetSize;
    private int windowSize;
    private FastVector alphabet;
    private final boolean useParamSearch;

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "J. Lin and R. Khade and Y. Li");
        result.setValue(TechnicalInformation.Field.TITLE, "Rotation-invariant similarity in time series using bag-of-patterns representation");
        result.setValue(TechnicalInformation.Field.JOURNAL, "Journal of Intelligent Information Systems");
        result.setValue(TechnicalInformation.Field.VOLUME, "39");
        result.setValue(TechnicalInformation.Field.NUMBER, "2");
        result.setValue(TechnicalInformation.Field.PAGES, "287-315");
        result.setValue(TechnicalInformation.Field.YEAR, "2012");
        return result;
    }

    public BagOfPatterns() {
        this.PAA_intervalsPerWindow = -1;
        this.SAX_alphabetSize = -1;
        this.windowSize = -1;
        this.knn = new kNN();
        this.useParamSearch = true;
    }

    public BagOfPatterns(int PAA_intervalsPerWindow, int SAX_alphabetSize, int windowSize) {
        this.PAA_intervalsPerWindow = PAA_intervalsPerWindow;
        this.SAX_alphabetSize = SAX_alphabetSize;
        this.windowSize = windowSize;
        this.bop = new BagOfPatternsFilter(PAA_intervalsPerWindow, SAX_alphabetSize, windowSize);
        this.knn = new kNN();
        this.alphabet = SAX.getAlphabet(SAX_alphabetSize);
        this.useParamSearch = false;
    }

    public int getPAA_intervalsPerWindow() {
        return this.PAA_intervalsPerWindow;
    }

    public int getSAX_alphabetSize() {
        return this.SAX_alphabetSize;
    }

    public int getWindowSize() {
        return this.windowSize;
    }

    public int[] getParameterArray() {
        return new int[]{this.PAA_intervalsPerWindow, this.SAX_alphabetSize, this.windowSize};
    }

    public static int[] parameterSearch(Instances data) throws Exception {
        double bestAcc = 0.0;
        int bestAlpha = 0;
        int bestWord = 0;
        int bestWindowSize = 0;
        int numTests = 5;
        int minWinSize = (int)((double)(data.numAttributes() - 1) * 0.15);
        int maxWinSize = (int)((double)(data.numAttributes() - 1) * 0.36);
        int winInc = (int)((double)(maxWinSize - minWinSize) / 10.0);
        if (winInc < 1) {
            winInc = 1;
        }
        for (int alphaSize = 2; alphaSize <= 8; ++alphaSize) {
            for (int winSize = minWinSize; winSize <= maxWinSize; winSize += winInc) {
                for (int wordSize = 2; wordSize <= winSize / 2; wordSize *= 2) {
                    BagOfPatterns bop = new BagOfPatterns(wordSize, alphaSize, winSize);
                    double acc = bop.crossValidate(data);
                    if (!(acc > bestAcc)) continue;
                    bestAcc = acc;
                    bestAlpha = alphaSize;
                    bestWord = wordSize;
                    bestWindowSize = winSize;
                }
            }
        }
        return new int[]{bestWord, bestAlpha, bestWindowSize};
    }

    private double crossValidate(Instances data) throws Exception {
        this.buildClassifier(data);
        double correct = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            if (this.classifyInstance(i) != data.get(i).classValue()) continue;
            correct += 1.0;
        }
        return correct / (double)data.numInstances();
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.trainResults.buildTime = System.currentTimeMillis();
        if (data.classIndex() != data.numAttributes() - 1) {
            throw new Exception("LinBoP_BuildClassifier: Class attribute not set as last attribute in dataset");
        }
        if (this.useParamSearch) {
            int[] params = BagOfPatterns.parameterSearch(data);
            this.PAA_intervalsPerWindow = params[0];
            this.SAX_alphabetSize = params[1];
            this.windowSize = params[2];
            this.bop = new BagOfPatternsFilter(this.PAA_intervalsPerWindow, this.SAX_alphabetSize, this.windowSize);
            this.alphabet = SAX.getAlphabet(this.SAX_alphabetSize);
        }
        if (this.PAA_intervalsPerWindow < 0) {
            throw new Exception("LinBoP_BuildClassifier: Invalid PAA word size: " + this.PAA_intervalsPerWindow);
        }
        if (this.PAA_intervalsPerWindow > this.windowSize) {
            throw new Exception("LinBoP_BuildClassifier: Invalid PAA word size, bigger than sliding window size: " + this.PAA_intervalsPerWindow + "," + this.windowSize);
        }
        if (this.SAX_alphabetSize < 0 || this.SAX_alphabetSize > 10) {
            throw new Exception("LinBoP_BuildClassifier: Invalid SAX alphabet size (valid=2-10): " + this.SAX_alphabetSize);
        }
        if (this.windowSize < 0 || this.windowSize > data.numAttributes() - 1) {
            throw new Exception("LinBoP_BuildClassifier: Invalid sliding window size: " + this.windowSize + " (series length " + (data.numAttributes() - 1) + ")");
        }
        this.matrix = this.bop.process(data);
        this.knn.buildClassifier(this.matrix);
        this.trainResults.buildTime = System.currentTimeMillis() - this.trainResults.buildTime;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        double[] hist = this.bop.bagToArray(this.bop.buildBag(instance));
        Instances newInsts = new Instances(this.matrix, 1);
        newInsts.add(new SparseInstance(1.0, hist));
        return this.knn.classifyInstance(newInsts.firstInstance());
    }

    public double classifyInstance(int test) {
        double bestDist = Double.MAX_VALUE;
        double nn = -1.0;
        Instance testInst = this.matrix.get(test);
        for (int i = 0; i < this.matrix.numInstances(); ++i) {
            double dist;
            if (i == test || !((dist = this.knn.distance(testInst, this.matrix.get(i))) < bestDist)) continue;
            bestDist = dist;
            nn = this.matrix.get(i).classValue();
        }
        return nn;
    }

    @Override
    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] hist = this.bop.bagToArray(this.bop.buildBag(instance));
        Instances newInsts = new Instances(this.matrix, 1);
        newInsts.add(new SparseInstance(1.0, hist));
        return this.knn.distributionForInstance(newInsts.firstInstance());
    }

    @Override
    public String getParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getParameters());
        sb.append(",SAXAlphabetSize,").append(this.getSAX_alphabetSize()).append(",WindowSize,");
        sb.append(this.getWindowSize()).append(",PAAIntervals,").append(this.getPAA_intervalsPerWindow());
        return sb.toString();
    }

    @Override
    public Capabilities getCapabilities() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void main(String[] args) {
        BagOfPatterns.basicTest();
    }

    public static void basicTest() {
        System.out.println("BOPBasicTest\n");
        try {
            Instances train = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TRAIN.arff");
            Instances test = ClassifierTools.loadData("C:\\tempbakeoff\\TSC Problems\\Car\\Car_TEST.arff");
            System.out.println(train.relationName());
            BagOfPatterns bop = new BagOfPatterns();
            System.out.println("Training starting");
            long start = System.nanoTime();
            bop.buildClassifier(train);
            double trainTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Training done (" + trainTime + "s)");
            System.out.print("Params: ");
            for (int p : bop.getParameterArray()) {
                System.out.print(p + " ");
            }
            System.out.println("");
            System.out.println("\nTesting starting");
            start = System.nanoTime();
            double acc = ClassifierTools.accuracy(test, bop);
            double testTime = (double)(System.nanoTime() - start) / 1.0E9;
            System.out.println("Testing done (" + testTime + "s)");
            System.out.println("\nACC: " + acc);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public String toString() {
        return "BagOfPatterns";
    }
}

