/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import statistics.distributions.Distribution;

public class TestResults {
    public double testStat;
    public double pValue;
    public String testName;
    public double h0;
    public int type;
    public double level = 0.05;
    public double criticalValue;
    public int df1;
    public int df2;
    public Distribution dist;

    public TestResults(String s) {
        this.testName = s;
        this.dist = null;
        this.h0 = 0.0;
        this.pValue = 0.0;
        this.testStat = 0.0;
    }

    public TestResults(String s, Distribution d) {
        this.testName = s;
        this.dist = d;
        this.h0 = 0.0;
        this.pValue = 0.0;
        this.testStat = 0.0;
    }

    public void findPValue() {
        if (this.dist == null) {
            return;
        }
        this.pValue = this.dist.getCDF(this.testStat);
        if (this.type == 1) {
            this.pValue = 1.0 - this.pValue;
        } else if (this.type == 0) {
            if (this.pValue > 0.5) {
                this.pValue = 1.0 - this.pValue;
            }
            this.pValue *= 2.0;
        }
    }

    public void findCriticalValue() {
        this.criticalValue = this.type == -1 ? this.dist.getQuantile(1.0 - this.level) : this.dist.getQuantile(this.level);
    }

    public String toString() {
        String str = "****** Results for " + this.testName + "   *********\n";
        str = str + " To test median =" + this.h0 + " against H1: ";
        str = this.type == -1 ? str + "median < " + this.h0 : (this.type == 1 ? str + "median > " + this.h0 : str + "median not equal to " + this.h0);
        str = str + "\n T = " + this.testStat + "\t p value = " + this.pValue + "\tlevel = " + this.level + "\n";
        str = str + " Distribution = " + this.dist + "\t Level =" + this.level + "\t Critical Value =" + this.criticalValue;
        return str;
    }
}

