/*
 * Decompiled with CFR 0.152.
 */
package statistics.tests;

import fileIO.InFile;
import java.text.DecimalFormat;
import java.util.Arrays;
import statistics.distributions.BinomialDistribution;
import statistics.distributions.NormalDistribution;
import statistics.distributions.StudentDistribution;
import statistics.tests.DataPoint;
import statistics.tests.TestResults;
import statistics.tests.Tests;

public class OneSampleTests
extends Tests {
    public static boolean beQuiet = false;
    private static DecimalFormat df = new DecimalFormat("##.########");
    public static DataPoint[] absRankedData;

    public String performTests(double[] data) {
        Object[] d = new DataPoint[data.length];
        boolean allthesame = true;
        for (int i = 0; i < data.length; ++i) {
            d[i] = new DataPoint(data[i], 0, i);
            if (!allthesame || d[i] == d[0]) continue;
            allthesame = false;
        }
        if (allthesame) {
            return "AllTheSame,0,0.5,AllTheSame,0,0.5,AllTheSame,0,0.5";
        }
        Arrays.sort(d);
        TestResults test = new TestResults("T_Test");
        OneSampleTests.studentTTest(test, (DataPoint[])d);
        test.findPValue();
        String str = "T_Test," + test.testStat + "," + df.format(test.pValue) + ",";
        test = new TestResults("SignTest");
        OneSampleTests.signTest(test, (DataPoint[])d);
        test.findPValue();
        str = str + "Sign_Test," + test.testStat + "," + df.format(test.pValue) + ",";
        test.findPValue();
        test = new TestResults("WilcoxonSignRankTest");
        OneSampleTests.wilcoxonSignRank(test, (DataPoint[])d);
        test.findPValue();
        str = str + "Sign_Rank_Test," + test.testStat + "," + df.format(test.pValue);
        return str;
    }

    public static void studentTTest(TestResults t, DataPoint[] data) {
        double tStat;
        int i;
        double mean = 0.0;
        double var = 0.0;
        for (i = 0; i < data.length; ++i) {
            mean += data[i].d;
        }
        mean /= (double)data.length;
        for (i = 0; i < data.length; ++i) {
            var += (mean - data[i].d) * (mean - data[i].d);
        }
        t.testStat = tStat = mean / Math.sqrt((var /= (double)(data.length - 1)) / (double)data.length);
        t.df1 = data.length - 1;
        t.dist = new StudentDistribution(t.df1);
    }

    public static void signTest(TestResults T, DataPoint[] ranked) {
        T.testName = "signTest";
        double s1 = 0.0;
        double s2 = 0.0;
        DataPoint h0 = new DataPoint(T.h0, 0, 0);
        int adjN = ranked.length;
        int pos = Arrays.binarySearch(ranked, h0);
        if (pos >= 0) {
            int dupCount = 1;
            int left = pos - 1;
            int right = pos + 1;
            while (left >= 0 && ranked[pos].equals(ranked[left])) {
                --left;
                ++dupCount;
            }
            while (right < ranked.length && ranked[pos].equals(ranked[right])) {
                ++right;
                ++dupCount;
            }
            if (dupCount % 2 == 1 && adjN < 50) {
                --adjN;
                --dupCount;
            }
            s1 = (double)(left + 1) + (double)dupCount / 2.0;
            s2 = (double)(ranked.length - right) + (double)dupCount / 2.0;
        } else {
            s1 = -pos - 1;
            s2 = (double)adjN - s2;
        }
        if (T.type == -1) {
            T.testStat = s2;
        } else if (T.type == 1) {
            T.testStat = s1;
        } else if (T.type == 0) {
            T.testStat = s1 < s2 ? s1 : s2;
        }
        T.dist = adjN < 50 ? new BinomialDistribution(adjN, 0.5) : new NormalDistribution((double)adjN / 2.0, Math.sqrt(adjN) / 2.0);
        T.findCriticalValue();
        T.findPValue();
    }

    public static void wilcoxonSignRank(TestResults T, DataPoint[] ranked) {
        double diff;
        T.testName = "wilcoxonSignRank";
        absRankedData = new DataPoint[ranked.length];
        int adjN = 0;
        for (int j = 0; j < ranked.length; ++j) {
            double d = diff = ranked[j].d > T.h0 ? ranked[j].d - T.h0 : T.h0 - ranked[j].d;
            if (!(diff > 0.0)) continue;
            OneSampleTests.absRankedData[adjN] = new DataPoint(diff, 0, j);
            ++adjN;
        }
        if (adjN < ranked.length) {
            DataPoint[] temp = new DataPoint[adjN];
            for (int i = 0; i < adjN; ++i) {
                temp[i] = absRankedData[i];
            }
            absRankedData = temp;
        }
        Arrays.sort(absRankedData);
        for (int i = 0; i < absRankedData.length; ++i) {
            OneSampleTests.absRankedData[i].rank = i + 1;
        }
        OneSampleTests.adjustRanksForDuplicates(absRankedData);
        double rankSumUnder = 0.0;
        double rankSumOver = 0.0;
        for (int j = 0; j < adjN; ++j) {
            diff = ranked[OneSampleTests.absRankedData[j].position].d - T.h0;
            if (!beQuiet) {
                System.out.println(" Rank = " + j + " Pos =" + OneSampleTests.absRankedData[j].position + " Val =" + ranked[OneSampleTests.absRankedData[j].position].d + " diff =" + diff + " Abs Val =" + OneSampleTests.absRankedData[j].d);
            }
            if (diff < 0.0) {
                if (!beQuiet) {
                    System.out.println(" Rank = " + OneSampleTests.absRankedData[j].rank + " Value =" + ranked[OneSampleTests.absRankedData[j].position].d + "\t diff =" + diff);
                }
                rankSumUnder += OneSampleTests.absRankedData[j].rank;
                continue;
            }
            rankSumOver += OneSampleTests.absRankedData[j].rank;
        }
        T.testStat = T.type == 1 ? rankSumUnder : (T.type == -1 ? rankSumOver : (rankSumOver < rankSumUnder ? rankSumUnder : rankSumOver));
        T.dist = new NormalDistribution((double)(adjN * (adjN + 1)) / 4.0, Math.sqrt((double)(adjN * (adjN + 1) * (2 * adjN + 1)) / 24.0));
        T.findCriticalValue();
        T.findPValue();
    }

    public static void main(String[] args) {
        int i;
        TestResults t = new TestResults("SignTest");
        InFile inf = new InFile("C:\\Users\\ajb\\Dropbox\\Results\\DebugFiles\\TwoSampleTest.csv");
        int n = inf.readInt();
        int m = inf.readInt();
        double[] diff = new double[m];
        for (i = 0; i < diff.length; ++i) {
            diff[i] = inf.readDouble();
        }
        i = 0;
        while (i < diff.length) {
            int n2 = i++;
            diff[n2] = diff[n2] - inf.readDouble();
        }
        OneSampleTests one = new OneSampleTests();
        System.out.println(one.performTests(diff));
    }
}

