/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import statistics.simulators.DataSimulator;
import statistics.simulators.Model;
import statistics.simulators.SinusoidalModel;
import weka.core.Instances;

public class SimulateWholeSeriesData
extends DataSimulator {
    static DataSimulator sim;

    public SimulateWholeSeriesData(double[][] paras) {
        super(paras);
        for (int i = 0; i < this.nosClasses; ++i) {
            this.models.add(new SinusoidalModel(paras[i]));
        }
    }

    public void setWarping() {
        for (Model m : this.models) {
            ((SinusoidalModel)m).setWarp(true);
        }
    }

    public static Instances generateWholeSeriesdData(int seriesLength, int[] casesPerClass) {
        Model[] sin = new SinusoidalModel[casesPerClass.length];
        SimulateWholeSeriesData.populateWholeSeriesModels((SinusoidalModel[])sin);
        sim = new DataSimulator(sin);
        sim.setSeriesLength(seriesLength);
        sim.setCasesPerClass(casesPerClass);
        Instances d = sim.generateDataSet();
        return d;
    }

    private static void populateWholeSeriesModels(SinusoidalModel[] m) {
        double[] paras = new double[]{0.0, 1.0, 1.0};
        for (int i = 0; i < m.length; ++i) {
            m[i] = new SinusoidalModel(paras);
            paras[0] = 1.0;
        }
    }
}

