/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import statistics.simulators.ArmaModel;
import statistics.simulators.DataSimulator;
import statistics.simulators.Model;
import statistics.simulators.SinusoidalModel;
import statistics.simulators.WhiteNoiseModel;
import timeseriesweka.classifiers.FastDTW_1NN;
import timeseriesweka.filters.ACF;
import timeseriesweka.filters.ARMA;
import timeseriesweka.filters.FFT;
import timeseriesweka.filters.PACF;
import utilities.ClassifierTools;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;
import weka.filters.NormalizeCase;

public class SimulateSpectralData
extends DataSimulator {
    public static String path = "C:\\Research\\Data\\RunLengthExperiments\\";
    public static double MIN_PARA_VALUE = -1.0;
    public static double MAX_PARA_VALUE = 1.0;
    static int defaultMinSize = 1;
    static int defaultMaxSize = 4;
    double[][] parameters;
    int minParas = defaultMinSize;
    int maxParas = defaultMaxSize;
    static double DIFF = 0.15;
    static double THRESH = 0.95;
    public Random rand = new Random();

    public SimulateSpectralData() {
        this.minParas = defaultMinSize;
        this.maxParas = defaultMaxSize;
        boolean validated = false;
        int maxRuns = 0;
        int[] temp = this.casesPerClass;
        int temp2 = this.nosPerClass;
        while (maxRuns < 10 && !validated) {
            this.parameters = this.generateModels();
            this.nosClasses = this.parameters.length;
            this.models = new ArrayList(this.nosClasses);
            for (int i = 0; i < this.nosClasses; ++i) {
                this.models.add(new ArmaModel(this.parameters[i]));
            }
            this.setCasesPerClass(new int[]{20, 20});
            this.setLength(100);
            try {
                Instances[] data = this.generateTrainTest();
                FastDTW_1NN c = new FastDTW_1NN();
                double acc = ClassifierTools.singleTrainTestSplitAccuracy(c, data[0], data[1]);
                if (acc < THRESH) {
                    validated = true;
                }
                ++maxRuns;
            }
            catch (Exception e) {
                ++maxRuns;
                validated = false;
            }
        }
        this.casesPerClass = temp;
        this.nosPerClass = temp2;
    }

    public SimulateSpectralData(int seed) {
        this();
        this.rand = new Random(seed);
    }

    public static void setMinMaxPara(double a, double b) {
        MIN_PARA_VALUE = a;
        MAX_PARA_VALUE = b;
    }

    public final double[][] generateModels() {
        double[][] p = new double[this.nosClasses][];
        p[0] = SimulateSpectralData.generateStationaryParameters(this.minParas, this.maxParas);
        for (int i = 1; i < this.nosClasses; ++i) {
            p[i] = new double[p[0].length];
            for (int j = 0; j < p[0].length; ++j) {
                p[i][j] = this.rand.nextDouble() < 0.5 ? p[i - 1][j] - DIFF : p[i - 1][j] - DIFF;
                if (p[i][j] < 0.0) {
                    p[i][j] = 0.0;
                    continue;
                }
                if (!(p[i][j] > 1.0)) continue;
                p[i][j] = 1.0;
            }
        }
        return p;
    }

    public void randomiseModel() {
        int i;
        this.parameters = new double[this.nosClasses][];
        for (i = 0; i < this.parameters.length; ++i) {
            this.parameters[i] = SimulateSpectralData.generateStationaryParameters(this.minParas, this.maxParas);
        }
        this.nosClasses = this.parameters.length;
        this.models = new ArrayList(this.nosClasses);
        for (i = 0; i < this.nosClasses; ++i) {
            this.models.add(new ArmaModel(this.parameters[i]));
        }
    }

    public void randomiseModel(int min, int max) {
        this.minParas = min;
        this.maxParas = max;
        this.randomiseModel();
    }

    public void randomiseModel(int min, int max, int numClasses) {
        this.nosClasses = numClasses;
        this.minParas = min;
        this.maxParas = max;
        this.randomiseModel();
    }

    public void randomiseModel(int min, int max, int numClasses, int length) {
        this.nosClasses = numClasses;
        this.seriesLength = length;
        this.minParas = min;
        this.maxParas = max;
        this.randomiseModel();
    }

    public SimulateSpectralData(double[][] paras) {
        super(paras);
        for (int i = 0; i < this.nosClasses; ++i) {
            this.models.add(new ArmaModel(paras[i]));
        }
    }

    @Override
    public void initialise() {
        for (Model a : this.models) {
            ((ArmaModel)a).randomise();
        }
    }

    @Override
    public double[] generate(int length, int modelNos) {
        double[] d = new double[length];
        Model a = (Model)this.models.get(modelNos);
        for (int i = 0; i < length; ++i) {
            d[i] = a.generate();
        }
        return d;
    }

    public static void testARMA() {
        int i;
        int j;
        int nosParas = (int)(Math.random() * 11.0);
        DecimalFormat dc = new DecimalFormat("###.###");
        double[][] paras = new double[2][nosParas];
        for (j = 0; j < nosParas; ++j) {
            paras[0][j] = -0.95 + 1.8 * Math.random();
        }
        System.out.print("\nInput coefficients");
        for (int i2 = 0; i2 < paras[0].length; ++i2) {
            System.out.print(dc.format(paras[0][i2]) + "\t");
        }
        System.out.print("\n");
        paras[0] = SimulateSpectralData.findCoefficients(paras[0]);
        for (j = 0; j < nosParas; ++j) {
            paras[1][j] = paras[0][j] - 0.1 + 0.2 * Math.random();
        }
        int n = 200;
        double[] d1 = SimulateSpectralData.generate(paras[0], n);
        double[] d2 = SimulateSpectralData.generate(paras[0], n);
        for (int i3 = 0; i3 < d1.length; ++i3) {
            System.out.print(dc.format(d1[i3]) + "\t");
        }
        double[] f1 = ARMA.fitAR(d1);
        double[] f2 = ARMA.fitAR(d2);
        System.out.println("\n\nModel length =" + nosParas);
        System.out.print("\nACTUAL MODEL 1=");
        for (i = 0; i < paras[0].length; ++i) {
            System.out.print(dc.format(paras[0][i]) + "\t");
        }
        System.out.print("\nFITTED MODEL 1=");
        for (i = 0; i < f1.length; ++i) {
            System.out.print(dc.format(f1[i]) + "\t");
        }
        System.out.println("\n\nModel length =" + nosParas);
        System.out.print("\nACTUAL MODEL 2=");
        for (i = 0; i < paras[0].length; ++i) {
            System.out.print(dc.format(paras[1][i]) + "\t");
        }
        System.out.print("\nFITTED MODEL 2=");
        for (i = 0; i < f2.length; ++i) {
            System.out.print(dc.format(f2[i]) + "\t");
        }
    }

    public static Instances generateSpectralEmbeddedData(int s, int[] casesPerClass) {
        int startPos;
        SimulateSpectralData ds = new SimulateSpectralData();
        ds.setCasesPerClass(casesPerClass);
        int fullLength = s;
        int arLength = fullLength / 2;
        ds.setLength(arLength);
        Instances data = ds.generateDataSet();
        NormalizeCase nc = new NormalizeCase();
        try {
            data = nc.process(data);
        }
        catch (Exception e) {
            System.out.println("Normalisation failed : " + e);
        }
        ArrayList<Model> noise = new ArrayList<Model>();
        WhiteNoiseModel wm = new WhiteNoiseModel();
        noise.add(wm);
        wm = new WhiteNoiseModel();
        noise.add(wm);
        DataSimulator ds2 = new DataSimulator(noise);
        ds2.setCasesPerClass(casesPerClass);
        ds2.setLength(fullLength);
        Instances noiseData = ds2.generateDataSet();
        for (int j = startPos = (int)(Math.random() * (double)(fullLength - arLength)); j < startPos + arLength; ++j) {
            for (int k = 0; k < data.numInstances(); ++k) {
                noiseData.instance(k).setValue(j, data.instance(k).value(j - startPos));
            }
        }
        return noiseData;
    }

    public static void testFFT(String fileName) {
        int n = 32;
        int[] cases = new int[]{1, 1};
        FFT ar = new FFT();
        double[][] paras = new double[][]{{1.3532, 0.4188, -1.2153, 0.3091, 0.1877, -0.0876, 0.0075, 4.0E-4}, {1.0524, 0.9042, -1.2193, 0.0312, 0.263, -0.0567, -0.0019}};
        Instances train = SimulateSpectralData.generateARDataSet(paras, n, cases);
        OutFile of = new OutFile(fileName);
        try {
            int i;
            DecimalFormat dc = new DecimalFormat("###.####");
            Instances arTrain = ar.process(train);
            Instance in1 = train.instance(0);
            System.out.print("\nFitted Data Full >\t");
            for (int i2 = 0; i2 < in1.numAttributes() - 1; ++i2) {
                of.writeString(in1.value(i2) + ",");
                System.out.print(in1.value(i2) + ",");
            }
            of.writeString("\n");
            Instance in2 = arTrain.instance(0);
            System.out.print("\nFitted FFT Full >\t");
            for (i = 0; i < in2.numAttributes(); ++i) {
                System.out.print(dc.format(in2.value(i)) + ",");
                of.writeString(dc.format(in2.value(i)) + ",");
            }
            ar.truncate(arTrain, n / 4);
            System.out.print("\nFitted FFT Truncated >\t");
            of.writeString("\n");
            for (i = 0; i < in2.numAttributes(); ++i) {
                System.out.print(dc.format(in2.value(i)) + ",");
                of.writeString(dc.format(in2.value(i)) + ",");
            }
        }
        catch (Exception e) {
            System.out.println("Exception =" + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void testAIC(String fileName) {
        int n = 100;
        int[] cases = new int[]{1, 1};
        ARMA ar = new ARMA();
        ar.setUseAIC(false);
        int maxLag = n / 4;
        ar.setMaxLag(maxLag);
        double[][] paras = new double[][]{{1.3532, 0.4188, -1.2153, 0.3091, 0.1877, -0.0876, 0.0075, 4.0E-4}, {1.0524, 0.9042, -1.2193, 0.0312, 0.263, -0.0567, -0.0019}};
        Instances train = SimulateSpectralData.generateARDataSet(paras, n, cases);
        try {
            int i;
            DecimalFormat dc = new DecimalFormat("###.####");
            Instances arTrain = ar.process(train);
            Instance in1 = train.instance(0);
            Instance in2 = arTrain.instance(0);
            System.out.print("Actual Model >\t\t");
            for (i = 0; i < paras[0].length; ++i) {
                System.out.print(dc.format(paras[0][i]) + ",");
            }
            System.out.print("\nFitted Model No AIC >\t");
            for (i = 0; i < in2.numAttributes(); ++i) {
                System.out.print(dc.format(in2.value(i)) + ",");
            }
            ar.setUseAIC(true);
            arTrain = ar.process(train);
            in2 = arTrain.instance(0);
            System.out.print("\nFitted Model AIC >\t");
            for (i = 0; i < in2.numAttributes(); ++i) {
                System.out.print(dc.format(in2.value(i)) + ",");
            }
            OutFile of = new OutFile(fileName);
            for (int i2 = 0; i2 < in1.numAttributes() - 1; ++i2) {
                of.writeString(in1.value(i2) + ",");
            }
            double[] d = in1.toDoubleArray();
            double[] d2 = new double[d.length - 1];
            for (int i3 = 0; i3 < d2.length; ++i3) {
                d2[i3] = d[i3];
            }
            System.out.println("Auto Corellations >");
            double[] autos = ACF.fitAutoCorrelations(d2, maxLag);
            of.writeString("\n");
            of.writeString("\n");
            for (int i4 = 0; i4 < autos.length; ++i4) {
                of.writeString(autos[i4] + ",");
                System.out.println(autos[i4] + ",");
            }
            of.writeString("\n");
            of.writeString("\n");
            double[][] partials = PACF.formPartials(autos);
            for (int i5 = 0; i5 < partials.length; ++i5) {
                for (int j = 0; j < partials[i5].length; ++j) {
                    of.writeString(partials[i5][j] + ",");
                }
                of.writeString("\n");
            }
            int best = ARMA.findBestAIC(autos, partials, maxLag, d2);
            System.out.println(" Best Length = " + best);
        }
        catch (Exception e) {
            System.out.println("Exception =" + e);
            System.exit(0);
        }
    }

    public static void generateAR1(int n, double[][] p, String fileName) {
        int j;
        double[] d;
        int i;
        DecimalFormat df = new DecimalFormat("####.####");
        int nosCases = 200;
        double diff = 0.05;
        String newline = System.getProperty("line.separator");
        SimulateSpectralData ar = new SimulateSpectralData(p);
        String arffHeader = "@relation AR1Models\n";
        for (int i2 = 0; i2 < n; ++i2) {
            arffHeader = arffHeader + "@attribute T" + i2 + " real" + newline;
        }
        arffHeader = arffHeader + "@attribute targetClass {0,1}" + newline;
        arffHeader = arffHeader + "@data" + newline + newline;
        OutFile of = new OutFile(path + "AR1\\train" + fileName);
        of.writeString(arffHeader);
        for (i = 0; i < nosCases; ++i) {
            ar.initialise();
            d = ar.generate(n, 0);
            for (j = 0; j < d.length; ++j) {
                of.writeString(df.format(d[j]) + ",");
            }
            of.writeString("0" + newline);
            d = ar.generate(n, 1);
            for (j = 0; j < d.length; ++j) {
                of.writeString(df.format(d[j]) + ",");
            }
            of.writeString("1" + newline);
        }
        of = new OutFile(path + "AR1\\test" + fileName);
        of.writeString(arffHeader);
        for (i = 0; i < nosCases; ++i) {
            ar.initialise();
            d = ar.generate(n, 0);
            for (j = 0; j < d.length; ++j) {
                of.writeString(df.format(d[j]) + ",");
            }
            of.writeString("0\n");
            d = ar.generate(n, 1);
            for (j = 0; j < d.length; ++j) {
                of.writeString(df.format(d[j]) + ",");
            }
            of.writeString("1\n");
        }
    }

    public static double[] findCoefficients(double[] c) {
        int i;
        int n = c.length;
        double[] a = new double[1];
        double[] aNew = null;
        a[0] = 1.0;
        for (int j = 1; j <= n; ++j) {
            aNew = new double[j + 1];
            aNew[0] = 1.0;
            for (i = 1; i < j; ++i) {
                aNew[i] = a[i] - a[i - 1] * c[j - 1];
            }
            aNew[j] = a[j - 1] * -c[j - 1];
            a = aNew;
        }
        double[] f = new double[n];
        for (i = 0; i < n; ++i) {
            f[i] = -a[i + 1];
        }
        return f;
    }

    public static double[] generate(double[] paras, int n) {
        double[] d = new double[n];
        ArmaModel ar = new ArmaModel(paras);
        ar.randomise();
        for (int i = 0; i < n; ++i) {
            d[i] = ar.generate();
        }
        return d;
    }

    public static double[] generateStationaryParameters(int minP, int maxP) {
        int nosParas = minP + (int)(1.0 + (double)maxP * Model.rand.nextDouble());
        double[] paras = new double[nosParas];
        for (int j = 0; j < nosParas; ++j) {
            paras[j] = MIN_PARA_VALUE + (MAX_PARA_VALUE - MIN_PARA_VALUE) * Model.rand.nextDouble();
        }
        paras = SimulateSpectralData.findCoefficients(paras);
        return paras;
    }

    public static void armaTest() {
        int i;
        int j;
        int nosParas = (int)(Model.rand.nextDouble() * 11.0);
        DecimalFormat dc = new DecimalFormat("###.###");
        double[][] paras = new double[2][nosParas];
        for (j = 0; j < nosParas; ++j) {
            paras[0][j] = -0.95 + 1.8 * Model.rand.nextDouble();
        }
        System.out.print("\nInput coefficients");
        for (int i2 = 0; i2 < paras[0].length; ++i2) {
            System.out.print(dc.format(paras[0][i2]) + "\t");
        }
        System.out.print("\n");
        paras[0] = SimulateSpectralData.findCoefficients(paras[0]);
        for (j = 0; j < nosParas; ++j) {
            paras[1][j] = paras[0][j] - 0.1 + 0.2 * Model.rand.nextDouble();
        }
        int n = 200;
        double[] d1 = SimulateSpectralData.generate(paras[0], n);
        double[] d2 = SimulateSpectralData.generate(paras[0], n);
        for (int i3 = 0; i3 < d1.length; ++i3) {
            System.out.print(dc.format(d1[i3]) + "\t");
        }
        double[] f1 = ARMA.fitAR(d1);
        double[] f2 = ARMA.fitAR(d2);
        System.out.println("\n\nModel length =" + nosParas);
        System.out.print("\nACTUAL MODEL 1=");
        for (i = 0; i < paras[0].length; ++i) {
            System.out.print(dc.format(paras[0][i]) + "\t");
        }
        System.out.print("\nFITTED MODEL 1=");
        for (i = 0; i < f1.length; ++i) {
            System.out.print(dc.format(f1[i]) + "\t");
        }
        System.out.println("\n\nModel length =" + nosParas);
        System.out.print("\nACTUAL MODEL 2=");
        for (i = 0; i < paras[0].length; ++i) {
            System.out.print(dc.format(paras[1][i]) + "\t");
        }
        System.out.print("\nFITTED MODEL 2=");
        for (i = 0; i < f2.length; ++i) {
            System.out.print(dc.format(f2[i]) + "\t");
        }
    }

    public static Instances generateOffByOneARDataSet(int p, int seriesLength, int[] nosCases, boolean normalize) {
        double[][] paras = new double[nosCases.length][];
        paras[0] = SimulateSpectralData.generateStationaryParameters(p, p);
        for (int i = 1; i < paras.length; ++i) {
            paras[i] = SimulateSpectralData.generateStationaryParameters(p + i, p + i);
        }
        Instances d = SimulateSpectralData.generateARDataSet(paras, seriesLength, nosCases);
        if (normalize) {
            try {
                NormalizeCase norm = new NormalizeCase();
                norm.setNormType(NormalizeCase.NormType.STD_NORMAL);
                d = norm.process(d);
            }
            catch (Exception e) {
                System.out.println("Exception e" + e);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return d;
    }

    public static Instances generateARDataSet(int seriesLength, int[] nosCases, boolean normalize) {
        return SimulateSpectralData.generateARDataSet(defaultMinSize, defaultMaxSize, seriesLength, nosCases, normalize);
    }

    public static Instances generateARDataSet(int minParas, int maxParas, int seriesLength, int[] nosCases, boolean normalize) {
        double[][] paras = new double[nosCases.length][];
        for (int i = 0; i < paras.length; ++i) {
            paras[i] = SimulateSpectralData.generateStationaryParameters(minParas, maxParas);
        }
        Instances d = SimulateSpectralData.generateARDataSet(paras, seriesLength, nosCases);
        if (normalize) {
            try {
                NormalizeCase norm = new NormalizeCase();
                norm.setNormType(NormalizeCase.NormType.STD_NORMAL);
                d = norm.process(d);
            }
            catch (Exception e) {
                System.out.println("Exception e" + e);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return d;
    }

    public static Instances generateARDataSet(int minParas, int maxParas, int seriesLength, int[] nosCases) {
        return SimulateSpectralData.generateARDataSet(minParas, maxParas, seriesLength, nosCases, false);
    }

    public static Instances generateARDataSet(double[][] p, int seriesLength, int[] nosCases) {
        int i;
        SimulateSpectralData ar = new SimulateSpectralData(p);
        FastVector<Attribute> atts = new FastVector<Attribute>();
        int totalCases = nosCases[0];
        for (i = 1; i < nosCases.length; ++i) {
            totalCases += nosCases[i];
        }
        for (i = 1; i <= seriesLength; ++i) {
            atts.addElement(new Attribute("t" + i));
        }
        FastVector<String> fv = new FastVector<String>();
        for (int i2 = 0; i2 < ar.nosClasses; ++i2) {
            fv.addElement("" + i2);
        }
        atts.addElement(new Attribute("Target", fv));
        Instances data = new Instances("AR", atts, totalCases);
        for (int i3 = 0; i3 < ar.nosClasses; ++i3) {
            for (int j = 0; j < nosCases[i3]; ++j) {
                ar.initialise();
                double[] d = ar.generate(seriesLength, i3);
                Instance in = new DenseInstance(data.numAttributes());
                for (int k = 0; k < d.length; ++k) {
                    in.setValue(k, d[k]);
                }
                data.add(in);
                in = data.lastInstance();
                in.setValue(d.length, "" + i3);
            }
        }
        data.setClassIndex(seriesLength);
        return data;
    }

    public static Instances generateFFTDataSet(int minParas, int maxParas, int seriesLength, int[] nosCases, boolean normalize) {
        int i;
        double[][] paras = new double[nosCases.length][];
        Random rand = new Random();
        Model[] sm = new SinusoidalModel[nosCases.length];
        int modelSize = minParas + rand.nextInt(maxParas - minParas);
        paras[0] = new double[3 * modelSize];
        for (int j = 0; j < paras.length; ++j) {
            paras[0][j] = rand.nextDouble();
        }
        for (i = 1; i < sm.length; ++i) {
            paras[i] = new double[3 * modelSize];
            for (int j = 0; j < paras.length; ++j) {
                paras[i][j] = paras[0][j];
                double[] dArray = paras[i];
                int n = j;
                dArray[n] = dArray[n] + (-0.1 + 0.2 * rand.nextDouble());
                if (!(paras[i][j] < 0.0) && !(paras[i][j] > 1.0)) continue;
                paras[i][j] = paras[0][j];
            }
        }
        for (i = 0; i < sm.length; ++i) {
            sm[i] = new SinusoidalModel(paras[i]);
            ((SinusoidalModel)sm[i]).setFixedOffset(false);
        }
        DataSimulator ds = new DataSimulator(sm);
        ds.setSeriesLength(seriesLength);
        ds.setCasesPerClass(nosCases);
        Instances d = ds.generateDataSet();
        if (normalize) {
            try {
                NormalizeCase norm = new NormalizeCase();
                norm.setNormType(NormalizeCase.NormType.STD_NORMAL);
                d = norm.process(d);
            }
            catch (Exception e) {
                System.out.println("Exception e" + e);
                e.printStackTrace();
                System.exit(0);
            }
        }
        return d;
    }

    public static void main(String[] args) {
        System.out.println("Running SimulateAR test harness");
        ArmaModel.setGlobalVariance(1.0);
        int[] cases = new int[]{2, 2};
        Instances d = SimulateSpectralData.generateARDataSet(1, 1, 200, cases, false);
        ArmaModel.setGlobalVariance(10.0);
        Instances d2 = SimulateSpectralData.generateARDataSet(1, 1, 200, cases, false);
        OutFile of = new OutFile("C:\\\\Research\\Results\\AR1_1.csv");
        OutFile of2 = new OutFile("C:\\\\Research\\Results\\AR1_10.csv");
        of.writeString(d.toString());
        of2.writeString(d2.toString());
        try {
            NormalizeCase norm = new NormalizeCase();
            norm.setNormType(NormalizeCase.NormType.STD_NORMAL);
            d = norm.process(d);
        }
        catch (Exception e) {
            System.out.println("Exception e" + e);
            e.printStackTrace();
            System.exit(0);
        }
    }

    @Override
    public String getParameters() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

