/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import statistics.simulators.DataSimulator;
import statistics.simulators.DictionaryModel;
import statistics.simulators.IntervalModel;
import statistics.simulators.Model;
import utilities.InstanceTools;
import weka.core.Instances;

public class SimulateIntervalData {
    static DataSimulator sim;
    static int intervalLength;
    static int nosIntervals;
    static int noiseToSignal;
    static double base;
    static double amp;

    public static void setNosIntervals(int n) {
        nosIntervals = n;
    }

    public static void setNoiseToSignal(int n) {
        noiseToSignal = n;
    }

    public static void setAmp(double a) {
        amp = a;
        base = -amp / 2.0;
    }

    public static Instances generateIntervalData(int seriesLength, int[] casesPerClass) {
        int s = Model.getRandomSeed();
        intervalLength = seriesLength / (nosIntervals * noiseToSignal);
        DictionaryModel.Shape.DEFAULTBASE = base;
        DictionaryModel.Shape.DEFAULTAMP = amp;
        Model[] intervalMod = new IntervalModel[casesPerClass.length];
        SimulateIntervalData.populateIntervalModels((IntervalModel[])intervalMod, seriesLength);
        sim = new DataSimulator(intervalMod);
        sim.setSeriesLength(seriesLength);
        sim.setCasesPerClass(casesPerClass);
        Instances d = sim.generateDataSet();
        return d;
    }

    private static void populateIntervalModels(IntervalModel[] m, int seriesLength) {
        if (m.length != 2) {
            System.out.println("ONLY IMPLEMENTED FOR TWO CLASSES");
        }
        IntervalModel m1 = new IntervalModel();
        m1.setSeriesLength(seriesLength);
        m1.setNoiseToSignal(noiseToSignal);
        m1.setNosIntervals(nosIntervals);
        m1.createIntervals();
        IntervalModel m2 = new IntervalModel();
        m2.setSeriesLength(seriesLength);
        m1.setNoiseToSignal(noiseToSignal);
        m2.setNosIntervals(nosIntervals);
        m2.setIntervals(m1.getIntervals(), m1.getIntervalLength());
        m1.randomiseShape(null);
        m2.randomiseShape(m1);
        m[0] = m1;
        m[1] = m2;
    }

    public static void main(String[] args) {
        Model.setDefaultSigma(0.0);
        Model.setGlobalRandomSeed(0);
        int seriesLength = 500;
        int[] casesPerClass = new int[]{2, 2};
        SimulateIntervalData.setNosIntervals(4);
        SimulateIntervalData.setNoiseToSignal(4);
        Instances d = SimulateIntervalData.generateIntervalData(seriesLength, casesPerClass);
        Instances[] split = InstanceTools.resampleInstances(d, 0L, 0.5);
        System.out.println(" DATA " + d);
        OutFile of = new OutFile("C:\\Temp\\intervalSimulationTest.csv");
        of.writeString(split[0].toString());
        of = new OutFile("C:\\Temp\\intervalSimulationTrain.csv");
        of.writeString(split[1].toString());
    }

    static {
        nosIntervals = 3;
        noiseToSignal = 4;
        base = -1.0;
        amp = 2.0;
    }
}

