/*
 * Decompiled with CFR 0.152.
 */
package statistics.simulators;

import fileIO.OutFile;
import java.util.ArrayList;
import statistics.distributions.Distribution;
import statistics.distributions.NormalDistribution;
import statistics.simulators.Model;

public class HMM_Model
extends Model {
    int N;
    Distribution[] f;
    double[][] T;
    double[] pi;
    int state;
    int n = 200;
    ArrayList stateRecord;
    ArrayList dataRecord;

    private HMM_Model() {
        System.out.println("SHOULD NOT BE HERE!!");
    }

    private HMM_Model(int models) {
        this.N = models;
        this.f = new NormalDistribution[this.N];
        this.T = new double[this.N][this.N];
        this.pi = new double[this.N];
    }

    private HMM_Model(int models, double[] means, double[] stDevs, double[][] trans, double[] inits) {
        this.N = models;
        this.f = new NormalDistribution[this.N];
        this.T = new double[this.N][this.N];
        this.pi = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.f[i] = new NormalDistribution(means[i], stDevs[i]);
            for (int j = 0; j < this.N; ++j) {
                this.T[i][j] = trans[i][j];
            }
            this.pi[i] = inits[i];
        }
        this.initialise();
    }

    public void initialise() {
        double r = Distribution.RNG.nextDouble();
        this.state = 0;
        double s = 0.0;
        boolean finished = false;
        do {
            if ((s += this.pi[this.state]) > r) {
                finished = true;
                continue;
            }
            ++this.state;
        } while (!finished && this.state < this.N);
        this.stateRecord = new ArrayList(this.n);
        this.dataRecord = new ArrayList(this.n);
    }

    @Override
    public double generate(double x) {
        System.out.println("Error, generate not implemented for HMM");
        System.exit(0);
        return -1.0;
    }

    @Override
    public double generate() {
        double r = Distribution.RNG.nextDouble();
        double s = 0.0;
        int i = 0;
        boolean finished = false;
        do {
            if ((s += this.T[this.state][i]) > r) {
                finished = true;
                continue;
            }
            ++i;
        } while (!finished && i < this.N);
        this.state = i;
        return this.f[this.state].simulate();
    }

    public String toString() {
        String str = "";
        return str;
    }

    public static void main(String[] args) {
        System.out.println("Testing HMM Models");
        System.out.println("Generating Data: from 2 normal dists, variance 1");
        OutFile f = new OutFile("SmytheHMMData.csv");
    }

    @Override
    public void setParameters(double[] p) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

