/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class UniformDistribution
extends Distribution {
    double values;

    public UniformDistribution(double a, double b) {
        this.setParameters(a, b);
    }

    public UniformDistribution() {
        this.setParameters(0.0, 1.0);
    }

    public void setParameters(double a, double b) {
        super.setParameters(a, b, 0.01, 1);
    }

    @Override
    public double getDensity(double x) {
        if (this.getDomain().getLowerValue() <= x & x <= this.getDomain().getUpperValue()) {
            return 1.0 / (double)this.getDomain().getSize();
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        return 1.0 / (double)this.getDomain().getSize();
    }

    @Override
    public double simulate() {
        return this.getDomain().getLowerValue() + RNG.nextDouble() * (this.getDomain().getUpperValue() - this.getDomain().getLowerValue());
    }
}

