/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class StudentDistribution
extends Distribution {
    private int degrees;
    private double c;

    public StudentDistribution(int n) {
        this.setDegrees(n);
    }

    public StudentDistribution() {
        this(1);
    }

    public void setDegrees(int n) {
        if (n < 1) {
            n = 1;
        }
        this.degrees = n;
        this.c = StudentDistribution.logGamma(0.5 * (double)(this.degrees + 1)) - 0.5 * Math.log(this.degrees) - 0.5 * Math.log(Math.PI) - StudentDistribution.logGamma(0.5 * (double)this.degrees);
        double upper = n == 1 ? 8.0 : (n == 2 ? 7.0 : Math.ceil(this.getMean() + 4.0 * this.getSD()));
        super.setParameters(-upper, upper, upper / 50.0, 1);
    }

    @Override
    public double getDensity(double x) {
        return Math.exp(this.c - 0.5 * (double)(this.degrees + 1) * Math.log(1.0 + x * x / (double)this.degrees));
    }

    @Override
    public double getMaxDensity() {
        return this.getDensity(0.0);
    }

    @Override
    public double getMean() {
        if (this.degrees == 1) {
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public double getVariance() {
        if (this.degrees == 1) {
            return Double.NaN;
        }
        if (this.degrees == 2) {
            return Double.POSITIVE_INFINITY;
        }
        return (double)this.degrees / (double)(this.degrees - 2);
    }

    @Override
    public double getCDF(double x) {
        double u = (double)this.degrees / ((double)this.degrees + x * x);
        if (x > 0.0) {
            return 1.0 - 0.5 * StudentDistribution.betaCDF(u, 0.5 * (double)this.degrees, 0.5);
        }
        return 0.5 * StudentDistribution.betaCDF(u, 0.5 * (double)this.degrees, 0.5);
    }

    public double getDegrees() {
        return this.degrees;
    }

    @Override
    public double simulate() {
        double z;
        double theta;
        double r;
        double v = 0.0;
        for (int i = 1; i <= this.degrees; ++i) {
            r = Math.sqrt(-2.0 * Math.log(Math.random()));
            theta = Math.PI * 2 * Math.random();
            z = r * Math.cos(theta);
            v += z * z;
        }
        r = Math.sqrt(-2.0 * Math.log(Math.random()));
        theta = Math.PI * 2 * Math.random();
        z = r * Math.cos(theta);
        return z / Math.sqrt(v / (double)this.degrees);
    }
}

