/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class LogNormalDistribution
extends Distribution {
    public static final double C = Math.sqrt(Math.PI * 2);
    private double mu;
    private double sigma;

    public LogNormalDistribution(double m, double s) {
        this.setParameters(m, s);
    }

    public LogNormalDistribution() {
        this(0.0, 1.0);
    }

    public void setParameters(double m, double s) {
        if (s <= 0.0) {
            s = 1.0;
        }
        this.mu = m;
        this.sigma = s;
        double upper = this.getMean() + 3.0 * this.getSD();
        super.setParameters(0.0, upper, 0.01 * upper, 1);
    }

    @Override
    public double getDensity(double x) {
        double z = (Math.log(x) - this.mu) / this.sigma;
        return Math.exp(-z * z / 2.0) / (x * C * this.sigma);
    }

    @Override
    public double getMaxDensity() {
        double mode = Math.exp(this.mu - this.sigma * this.sigma);
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return Math.exp(this.mu + this.sigma * this.sigma / 2.0);
    }

    @Override
    public double getVariance() {
        double a = this.mu + this.sigma * this.sigma;
        return Math.exp(2.0 * a) - Math.exp(this.mu + a);
    }

    @Override
    public double simulate() {
        double r = Math.sqrt(-2.0 * Math.log(Math.random()));
        double theta = Math.PI * 2 * Math.random();
        return Math.exp(this.mu + this.sigma * r * Math.cos(theta));
    }

    public double getMu() {
        return this.mu;
    }

    public void setMu(double m) {
        this.setParameters(m, this.sigma);
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double s) {
        this.setParameters(this.mu, s);
    }

    @Override
    public double getCDF(double x) {
        double z = (Math.log(x) - this.mu) / this.sigma;
        if (z >= 0.0) {
            return 0.5 + 0.5 * LogNormalDistribution.gammaCDF(z * z / 2.0, 0.5);
        }
        return 0.5 - 0.5 * LogNormalDistribution.gammaCDF(z * z / 2.0, 0.5);
    }
}

