/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;
import statistics.distributions.Domain;

public class LocationScaleDistribution
extends Distribution {
    private Distribution dist;
    private double location;
    private double scale;

    public LocationScaleDistribution(Distribution d, double a, double b) {
        this.setParameters(d, a, b);
    }

    public void setParameters(Distribution d, double a, double b) {
        double u;
        double l;
        this.dist = d;
        this.location = a;
        this.scale = b;
        Domain domain = this.dist.getDomain();
        double w = domain.getWidth();
        int t = this.dist.getType();
        if (t == 0) {
            l = domain.getLowerValue();
            u = domain.getUpperValue();
        } else {
            l = domain.getLowerBound();
            u = domain.getUpperBound();
        }
        if (this.scale == 0.0) {
            super.setParameters(this.location, this.location, 1.0, 0);
        } else if (this.scale < 0.0) {
            super.setParameters(this.location + this.scale * u, this.location + this.scale * l, -this.scale * w, t);
        } else {
            super.setParameters(this.location + this.scale * l, this.location + this.scale * u, this.scale * w, t);
        }
    }

    @Override
    public double getDensity(double x) {
        if (this.scale == 0.0) {
            if (x == this.location) {
                return 1.0;
            }
            return 0.0;
        }
        return this.dist.getDensity((x - this.location) / this.scale);
    }

    @Override
    public double getMaxDensity() {
        return this.dist.getMaxDensity();
    }

    @Override
    public double getMean() {
        return this.location + this.scale * this.dist.getMean();
    }

    @Override
    public double getVariance() {
        return this.scale * this.scale * this.dist.getVariance();
    }

    @Override
    public double simulate() {
        return this.location + this.scale * this.dist.simulate();
    }

    @Override
    public double getCDF(double x) {
        if (this.scale > 0.0) {
            return this.dist.getCDF((x - this.location) / this.scale);
        }
        return 1.0 - this.dist.getCDF((x - this.location) / this.scale);
    }

    @Override
    public double getQuantile(double p) {
        if (this.scale > 0.0) {
            return this.location + this.scale * this.dist.getQuantile(p);
        }
        return this.location + this.scale * this.dist.getQuantile(1.0 - p);
    }
}

