/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Domain;

public class IntervalData {
    private int size;
    private int maxFreq;
    private double value;
    private double minValue;
    private double maxValue;
    private double mean;
    private double meanSquare;
    private double mode;
    private int[] freq;
    private Domain domain;
    private String name;

    public IntervalData(Domain d, String n) {
        this.name = n;
        this.setDomain(d);
    }

    public IntervalData(double a, double b, double w, String n) {
        this(new Domain(a, b, w), n);
    }

    public IntervalData(Domain d) {
        this(d, "X");
    }

    public IntervalData(double a, double b, double w) {
        this(a, b, w, "X");
    }

    public IntervalData() {
        this(0.0, 1.0, 0.1);
    }

    public void setDomain(Domain d) {
        this.domain = d;
        this.reset();
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getName() {
        return this.name;
    }

    public void reset() {
        this.freq = new int[this.domain.getSize()];
        this.size = 0;
        this.minValue = this.domain.getUpperBound();
        this.maxValue = this.domain.getLowerBound();
        this.maxFreq = 0;
    }

    public void setValue(double x) {
        int i;
        this.value = x;
        ++this.size;
        this.mean = (double)(this.size - 1) / (double)this.size * this.mean + this.value / (double)this.size;
        this.meanSquare = (double)(this.size - 1) / (double)this.size * this.meanSquare + this.value * this.value / (double)this.size;
        if (this.value < this.minValue) {
            this.minValue = this.value;
        }
        if (this.value > this.maxValue) {
            this.maxValue = this.value;
        }
        if ((i = this.domain.getIndex(x)) >= 0 & i < this.domain.getSize()) {
            int n = i;
            this.freq[n] = this.freq[n] + 1;
            if (this.freq[i] > this.maxFreq) {
                this.maxFreq = this.freq[i];
                this.mode = this.domain.getValue(i);
            } else if (this.freq[i] == this.maxFreq) {
                this.mode = Double.NaN;
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public double getDomainValue(double x) {
        return this.domain.getValue(this.domain.getIndex(x));
    }

    public int getFreq(double x) {
        int i = this.domain.getIndex(x);
        if (i < 0 | i >= this.domain.getSize()) {
            return 0;
        }
        return this.freq[i];
    }

    public double getRelFreq(double x) {
        if (this.size > 0) {
            return (double)this.getFreq(x) / (double)this.size;
        }
        return 0.0;
    }

    public double getDensity(double x) {
        return this.getRelFreq(x) / this.domain.getWidth();
    }

    public double getMean() {
        return this.mean;
    }

    public double getIntervalMean() {
        double sum = 0.0;
        for (int i = 0; i < this.domain.getSize(); ++i) {
            sum += this.domain.getValue(i) * (double)this.freq[i];
        }
        return sum / (double)this.size;
    }

    public double getVarianceP() {
        double var = this.meanSquare - this.mean * this.mean;
        if (var < 0.0) {
            var = 0.0;
        }
        return var;
    }

    public double getSDP() {
        return Math.sqrt(this.getVarianceP());
    }

    public double getVariance() {
        return (double)this.size / (double)(this.size - 1) * this.getVarianceP();
    }

    public double getSD() {
        return Math.sqrt(this.getVariance());
    }

    public double getIntervalVariance() {
        double m = this.getIntervalMean();
        double sum = 0.0;
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double x = this.domain.getValue(i);
            sum += (x - m) * (x - m) * (double)this.freq[i];
        }
        return sum / (double)this.size;
    }

    public double getIntervalSD() {
        return Math.sqrt(this.getIntervalVariance());
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMedian(double a, double b) {
        int uRank;
        int lRank;
        double x;
        int sumFreq = 0;
        int numValues = 0;
        double lValue = a - 1.0;
        double uValue = b + 1.0;
        double w = this.domain.getWidth();
        for (x = a; x <= b + 0.5 * w; x += w) {
            numValues += this.getFreq(x);
        }
        if (2 * (numValues / 2) == numValues) {
            lRank = numValues / 2;
            uRank = lRank + 1;
        } else {
            uRank = lRank = (numValues + 1) / 2;
        }
        for (x = a; x <= b + 0.5 * w; x += w) {
            if (lValue == a - 1.0 & (sumFreq += this.getFreq(x)) >= lRank) {
                lValue = x;
            }
            if (!(uValue == b + 1.0 & sumFreq >= uRank)) continue;
            uValue = x;
        }
        return (uValue + lValue) / 2.0;
    }

    public double getMedian() {
        return this.getMedian(this.domain.getLowerValue(), this.domain.getUpperValue());
    }

    public double getQuartile(int i) {
        if (i < 1) {
            i = 1;
        } else if (i > 3) {
            i = 3;
        }
        if (i == 1) {
            return this.getMedian(this.domain.getLowerValue(), this.getMedian());
        }
        if (i == 2) {
            return this.getMedian();
        }
        return this.getMedian(this.getMedian(), this.domain.getUpperValue());
    }

    public double getMAD() {
        double mad = 0.0;
        double m = this.getMedian();
        for (int i = 0; i < this.domain.getSize(); ++i) {
            double x = this.domain.getValue(i);
            mad += this.getRelFreq(x) * Math.abs(x - m);
        }
        return mad;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxFreq() {
        return this.maxFreq;
    }

    public double getMaxRelFreq() {
        if (this.size > 0) {
            return (double)this.maxFreq / (double)this.size;
        }
        return 0.0;
    }

    public double getMaxDensity() {
        return this.getMaxRelFreq() / this.domain.getWidth();
    }

    public double getMode() {
        return this.mode;
    }
}

