/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class FiniteOrderStatisticDistribution
extends Distribution {
    Distribution dist;
    private int sampleSize;
    private int populationSize;
    private int order;

    public FiniteOrderStatisticDistribution(int N, int n, int k) {
        this.setParameters(N, n, k);
    }

    public FiniteOrderStatisticDistribution() {
        this(50, 10, 5);
    }

    public void setParameters(int N, int n, int k) {
        this.populationSize = N;
        this.sampleSize = n;
        this.order = k;
        super.setParameters(this.order, this.populationSize - this.sampleSize + this.order, 1.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int i = (int)Math.rint(x);
        return FiniteOrderStatisticDistribution.comb(i - 1, this.order - 1) * FiniteOrderStatisticDistribution.comb(this.populationSize - i, this.sampleSize - this.order) / FiniteOrderStatisticDistribution.comb(this.populationSize, this.sampleSize);
    }

    @Override
    public double getMean() {
        return (double)this.order * (double)(this.populationSize + 1) / (double)(this.sampleSize + 1);
    }

    @Override
    public double getVariance() {
        return (double)(this.populationSize + 1) * (double)(this.populationSize - this.sampleSize) * (double)this.order * (double)(this.sampleSize + 1 - this.order) / (double)((this.sampleSize + 1) * (this.sampleSize + 1) * (this.sampleSize + 2));
    }

    public void setPopulationSize(int N) {
        this.setParameters(N, this.sampleSize, this.order);
    }

    public int getPopulationSize() {
        return this.populationSize;
    }

    public void setSampleSize(int n) {
        this.setParameters(this.populationSize, n, this.order);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setOrder(int k) {
        this.setParameters(this.populationSize, this.sampleSize, k);
    }

    public int getOrder() {
        return this.order;
    }
}

