/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class FiniteDistribution
extends Distribution {
    private int n;
    private double[] prob;

    public FiniteDistribution(double a, double b, double w, double[] p) {
        this.setParameters(a, b, w, p);
    }

    public FiniteDistribution(double a, double b, double w) {
        super.setParameters(a, b, w, 0);
        this.n = this.getDomain().getSize();
        this.prob = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.prob[i] = 1.0 / (double)this.n;
        }
    }

    public FiniteDistribution() {
        this(1.0, 10.0, 1.0);
    }

    public void setParameters(double a, double b, double w, double[] p) {
        int i;
        super.setParameters(a, b, w, 0);
        this.n = this.getDomain().getSize();
        this.prob = new double[this.n];
        if (p.length != this.n) {
            p = new double[this.n];
        }
        double sum = 0.0;
        for (i = 0; i < this.n; ++i) {
            if (p[i] < 0.0) {
                p[i] = 0.0;
            }
            sum += p[i];
        }
        if (sum == 0.0) {
            for (i = 0; i < this.n; ++i) {
                this.prob[i] = 1.0 / (double)this.n;
            }
        } else {
            for (i = 0; i < this.n; ++i) {
                this.prob[i] = p[i] / sum;
            }
        }
    }

    @Override
    public double getDensity(double x) {
        int j = this.getDomain().getIndex(x);
        if (0 <= j & j < this.n) {
            return this.prob[j];
        }
        return 0.0;
    }

    public void setProbabilities(double[] p) {
        int i;
        if (p.length != this.n) {
            p = new double[this.n];
        }
        double sum = 0.0;
        for (i = 0; i < this.n; ++i) {
            if (p[i] < 0.0) {
                p[i] = 0.0;
            }
            sum += p[i];
        }
        if (sum == 0.0) {
            for (i = 0; i < this.n; ++i) {
                this.prob[i] = 1.0 / (double)this.n;
            }
        } else {
            for (i = 0; i < this.n; ++i) {
                this.prob[i] = p[i] / sum;
            }
        }
    }

    public double getProbability(int i) {
        if (i < 0) {
            i = 0;
        } else if (i >= this.n) {
            i = this.n - 1;
        }
        return this.prob[i];
    }

    public double[] getProbabilities() {
        return this.prob;
    }
}

