/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class DiscreteArcsineDistribution
extends Distribution {
    private int parameter;

    public DiscreteArcsineDistribution(int n) {
        this.setParameter(n);
    }

    public DiscreteArcsineDistribution() {
        this(10);
    }

    public void setParameter(int n) {
        this.parameter = n;
        this.setParameters(0.0, this.parameter, 2.0, 0);
    }

    @Override
    public double getDensity(double x) {
        int k = (int)x;
        return DiscreteArcsineDistribution.comb(k, k / 2) * DiscreteArcsineDistribution.comb(this.parameter - k, (this.parameter - k) / 2) / Math.pow(2.0, this.parameter);
    }

    @Override
    public double getMaxDensity() {
        return this.getDensity(0.0);
    }

    public int getParameter() {
        return this.parameter;
    }

    @Override
    public double simulate() {
        int lastZero = 0;
        int position = 0;
        for (int i = 1; i <= this.parameter; ++i) {
            int step = Math.random() < 0.5 ? 1 : -1;
            if ((position += step) != 0) continue;
            lastZero = i;
        }
        return lastZero;
    }
}

