/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.ContinuousUniformDistribution;
import statistics.distributions.Distribution;
import statistics.distributions.Domain;

public class Convolution
extends Distribution {
    private Distribution distribution;
    private int power;
    private double[][] pdf;

    public Convolution(Distribution d, int n) {
        this.setParameters(d, n);
    }

    public Convolution() {
        this(new ContinuousUniformDistribution(0.0, 1.0), 5);
    }

    public void setParameters(Distribution d, int n) {
        int k;
        if (n < 1) {
            n = 1;
        }
        this.distribution = d;
        this.power = n;
        Domain domain = this.distribution.getDomain();
        double l = domain.getLowerValue();
        double u = domain.getUpperValue();
        double w = domain.getWidth();
        int t = this.distribution.getType();
        double dx = t == 0 ? 1.0 : w;
        super.setParameters((double)this.power * l, (double)this.power * u, w, t);
        int m = domain.getSize();
        this.pdf = new double[this.power][];
        for (k = 0; k < n; ++k) {
            this.pdf[k] = new double[(k + 1) * m - k];
        }
        for (int j = 0; j < m; ++j) {
            this.pdf[0][j] = this.distribution.getDensity(domain.getValue(j));
        }
        for (k = 1; k < n; ++k) {
            for (int j = 0; j < (k + 1) * m - k; ++j) {
                double p = 0.0;
                for (int i = Math.max(0, j - m + 1); i < Math.min(j + 1, k * m - k + 1); ++i) {
                    p += this.pdf[k - 1][i] * this.pdf[0][j - i];
                }
                this.pdf[k][j] = p;
            }
        }
    }

    @Override
    public double getDensity(double x) {
        return this.pdf[this.power - 1][this.getDomain().getIndex(x)];
    }

    @Override
    public double getMean() {
        return (double)this.power * this.distribution.getMean();
    }

    @Override
    public double getVariance() {
        return (double)this.power * this.distribution.getVariance();
    }

    @Override
    public double simulate() {
        double sum = 0.0;
        for (int i = 0; i < this.power; ++i) {
            sum += this.distribution.simulate();
        }
        return sum;
    }

    public void setPower(int n) {
        this.setParameters(this.distribution, n);
    }

    public int getPower() {
        return this.power;
    }

    public void setDistribution(Distribution d) {
        this.setParameters(d, this.power);
    }

    public Distribution getDistribution() {
        return this.distribution;
    }
}

