/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class ContinuousUniformDistribution
extends Distribution {
    private double minValue;
    private double maxValue;

    public ContinuousUniformDistribution(double a, double b) {
        this.setParameters(a, b);
    }

    public ContinuousUniformDistribution() {
        this(0.0, 1.0);
    }

    public void setParameters(double a, double b) {
        this.minValue = a;
        this.maxValue = b;
        double step = 0.01 * (this.maxValue - this.minValue);
        super.setParameters(this.minValue, this.maxValue, step, 1);
    }

    @Override
    public double getDensity(double x) {
        if (this.minValue <= x & x <= this.maxValue) {
            return 1.0 / (this.maxValue - this.minValue);
        }
        return 0.0;
    }

    @Override
    public double getMaxDensity() {
        return 1.0 / (this.maxValue - this.minValue);
    }

    @Override
    public double getMean() {
        return (this.minValue + this.maxValue) / 2.0;
    }

    @Override
    public double getVariance() {
        return (this.maxValue - this.minValue) * (this.maxValue - this.minValue) / 12.0;
    }

    @Override
    public double getCDF(double x) {
        if (x < this.minValue) {
            return 0.0;
        }
        if (x >= this.maxValue) {
            return 1.0;
        }
        return (x - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public double getQuantile(double p) {
        if (p < 0.0) {
            p = 0.0;
        } else if (p > 1.0) {
            p = 1.0;
        }
        return this.minValue + (this.maxValue - this.minValue) * p;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    @Override
    public double simulate() {
        return this.minValue + Math.random() * (this.maxValue - this.minValue);
    }
}

