/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.GammaDistribution;

public class ChiSquareDistribution
extends GammaDistribution {
    int degrees;

    public ChiSquareDistribution(int n) {
        this.setDegrees(n);
    }

    public ChiSquareDistribution() {
        this(1);
    }

    public void setDegrees(int n) {
        if (n <= 0) {
            n = 1;
        }
        this.degrees = n;
        super.setParameters(0.5 * (double)this.degrees, 2.0);
    }

    public int getDegrees() {
        return this.degrees;
    }

    @Override
    public double simulate() {
        double V = 0.0;
        for (int i = 1; i <= this.degrees; ++i) {
            double r = Math.sqrt(-2.0 * Math.log(Math.random()));
            double theta = Math.PI * 2 * Math.random();
            double Z = r * Math.cos(theta);
            V += Z * Z;
        }
        return V;
    }
}

