/*
 * Decompiled with CFR 0.152.
 */
package statistics.distributions;

import statistics.distributions.Distribution;

public class BinomialDistribution
extends Distribution {
    private int trials;
    private double probability;

    public BinomialDistribution(int n, double p) {
        this.setParameters(n, p);
    }

    public BinomialDistribution() {
        this(10, 0.5);
    }

    public void setParameters(int n, double p) {
        if (n < 1) {
            n = 1;
        }
        if (p < 0.0) {
            p = 0.0;
        } else if (p > 1.0) {
            p = 1.0;
        }
        this.trials = n;
        this.probability = p;
        super.setParameters(0.0, this.trials, 1.0, 0);
    }

    public void setTrials(int n) {
        this.setParameters(n, this.probability);
    }

    public int getTrials() {
        return this.trials;
    }

    public void setProbability(double p) {
        this.setParameters(this.trials, p);
    }

    public double getProbability() {
        return this.probability;
    }

    @Override
    public double getDensity(double x) {
        int k = (int)Math.rint(x);
        if (k < 0 | k > this.trials) {
            return 0.0;
        }
        if (this.probability == 0.0) {
            if (k == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (this.probability == 1.0) {
            if (k == this.trials) {
                return 1.0;
            }
            return 0.0;
        }
        return BinomialDistribution.comb(this.trials, k) * Math.pow(this.probability, k) * Math.pow(1.0 - this.probability, this.trials - k);
    }

    @Override
    public double getMaxDensity() {
        double mode = Math.min(Math.floor((double)(this.trials + 1) * this.probability), (double)this.trials);
        return this.getDensity(mode);
    }

    @Override
    public double getMean() {
        return (double)this.trials * this.probability;
    }

    @Override
    public double getVariance() {
        return (double)this.trials * this.probability * (1.0 - this.probability);
    }

    @Override
    public double getCDF(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        if (x >= (double)this.trials) {
            return 1.0;
        }
        return 1.0 - BinomialDistribution.betaCDF(this.probability, x + 1.0, (double)this.trials - x);
    }

    @Override
    public double simulate() {
        int successes = 0;
        for (int i = 1; i <= this.trials; ++i) {
            if (!(Math.random() < this.probability)) continue;
            ++successes;
        }
        return successes;
    }
}

