/*
 * Decompiled with CFR 0.152.
 */
package papers.smoothing;

import development.DataSets;
import java.io.File;
import utilities.ClassifierTools;
import weka.attributeSelection.PrincipalComponents;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.converters.ArffSaver;

public class PCADatasetBulder {
    public static void makePCAUCRDatasets() throws Exception {
        boolean transformBack = false;
        String[] dsets = DataSets.fileNames;
        assert (dsets.length == 85);
        int folds = 30;
        String readPath = "Z:/Data/TSCProblems/";
        String writePath = transformBack ? "Z:/Data/TSCProblems_PCA_smoothed/" : "Z:/Data/TSCProblems_PCA_comps/";
        double[] vars = transformBack ? new double[]{0.9, 0.95, 0.99} : new double[]{0.9, 0.95, 0.99, 1.0};
        for (int varExpInd = 0; varExpInd < vars.length; ++varExpInd) {
            double VARIANCE_EXPLAINED = vars[varExpInd];
            System.out.println(VARIANCE_EXPLAINED);
            for (int dset = 0; dset < dsets.length; ++dset) {
                String filename = PCADatasetBulder.filenameBuild(dsets[dset], VARIANCE_EXPLAINED);
                new File(writePath + filename + "/").mkdir();
                System.out.println(filename);
                for (int f = 0; f < folds; ++f) {
                    Instances train = ClassifierTools.loadData(readPath + dsets[dset] + "/" + dsets[dset] + "_TRAIN.arff");
                    Instances test = ClassifierTools.loadData(readPath + dsets[dset] + "/" + dsets[dset] + "_TEST.arff");
                    PrincipalComponents pca = new PrincipalComponents();
                    pca.setVarianceCovered(VARIANCE_EXPLAINED);
                    pca.setTransformBackToOriginal(transformBack);
                    pca.buildEvaluator(train);
                    Instances pcatrain = pca.transformedData(train);
                    Instances pcatest = new Instances(pca.transformedHeader());
                    for (Instance instance : test) {
                        pcatest.add(pca.convertInstance(instance));
                    }
                    new File(writePath + filename + "/" + filename + f + "_TEST.arff").delete();
                    ArffSaver saver2 = new ArffSaver();
                    saver2.setInstances(pcatest);
                    saver2.setFile(new File(writePath + filename + "/" + filename + f + "_TEST.arff"));
                    saver2.writeBatch();
                }
            }
        }
    }

    public static String filenameBuild(String dset, double PCAvar) {
        String varStr = "";
        if (PCAvar == 1.0) {
            varStr = "1";
        } else {
            varStr = PCAvar + "";
            int oldLen = varStr.length();
            varStr = varStr.replace("0.", "");
            assert (varStr.length() == oldLen - 2);
        }
        return dset + "-PCA_" + varStr + "-";
    }

    public static double filenameGetPCAVar(String filename) {
        String varStr = filename.split("-")[1].split("_")[1];
        if (varStr.equals("1")) {
            return 1.0;
        }
        varStr = "0." + varStr;
        return Double.parseDouble(varStr);
    }

    public static String filenameGetDset(String filename) {
        return filename.split("-")[0];
    }

    public static int filenameGetFold(String filename) {
        return Integer.parseInt(filename.split("-")[2].split("_")[0]);
    }

    public static void main(String[] args) throws Exception {
        PCADatasetBulder.makePCAUCRDatasets();
    }
}

